package org.jboss.cache.pojo.testng;

import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class TestListener extends TestListenerAdapter
{
   public void onTestFailure(ITestResult arg0)
   {
      System.out.println("Failed: " + getName(arg0));
   }

   private String getName(ITestResult arg0)
   {
      return arg0.getTestClass().getName() + "." + arg0.getName();
   }

   public void onTestSkipped(ITestResult arg0)
   {
      System.out.println("Skiped: " + getName(arg0));
   }

   public void onTestStart(ITestResult arg0)
   {
     System.out.println("Running test: " + getName(arg0));
   }
}
