/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.List;
import javax.transaction.Transaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.AbstractVisitor;
import org.jboss.cache.commands.VersionedDataCommand;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.tx.OptimisticPrepareCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.TxInterceptor;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionEntry;

public class OptimisticTxInterceptor
extends TxInterceptor {
    protected final ModificationsReplayVisitor replayVisitor = new ModificationsReplayVisitor();

    public OptimisticTxInterceptor() {
        this.optimistic = true;
    }

    public Object visitOptimisticPrepareCommand(InvocationContext ctx, OptimisticPrepareCommand command) throws Throwable {
        return this.visitPrepareCommand(ctx, command);
    }

    public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        block8: {
            try {
                boolean implicitTransaction;
                Transaction tx = ctx.getTransaction();
                boolean bl = implicitTransaction = tx == null;
                if (implicitTransaction) {
                    tx = this.createLocalTx();
                    ctx.setTransaction(tx);
                }
                try {
                    Object retval = this.attachGtxAndPassUpChain(ctx, command);
                    if (implicitTransaction) {
                        this.copyInvocationScopeOptionsToTxScope(ctx);
                        this.copyForcedCacheModeToTxScope(ctx);
                        this.txManager.commit();
                    }
                    return retval;
                }
                catch (Throwable t) {
                    if (!implicitTransaction) break block8;
                    this.log.warn((Object)"Rolling back, exception encountered", t);
                    try {
                        this.copyInvocationScopeOptionsToTxScope(ctx);
                        this.copyForcedCacheModeToTxScope(ctx);
                        this.txManager.rollback();
                    }
                    catch (Throwable th) {
                        this.log.warn((Object)"Roll back failed encountered", th);
                    }
                    throw t;
                }
            }
            catch (Throwable th) {
                ctx.throwIfNeeded(th);
            }
        }
        return null;
    }

    private void copyForcedCacheModeToTxScope(InvocationContext ctx) {
        TransactionEntry entry;
        Option optionOverride = ctx.getOptionOverrides();
        if (optionOverride != null && (optionOverride.isForceAsynchronous() || optionOverride.isForceSynchronous()) && (entry = ctx.getTransactionEntry()) != null) {
            if (optionOverride.isForceAsynchronous()) {
                entry.setForceAsyncReplication(true);
            } else {
                entry.setForceSyncReplication(true);
            }
        }
    }

    protected PrepareCommand buildPrepareCommand(GlobalTransaction gtx, List modifications, boolean onePhaseCommit) {
        return this.commandsFactory.buildOptimisticPrepareCommand(gtx, modifications, null, this.rpcManager.getLocalAddress(), false);
    }

    protected void replayModifications(InvocationContext ctx, Transaction ltx, PrepareCommand command) throws Throwable {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Handling optimistic remote prepare " + ctx.getGlobalTransaction()));
        }
        try {
            this.replayVisitor.visitCollection(ctx, command.getModifications());
        }
        catch (Throwable t) {
            this.log.error((Object)"Prepare failed!", t);
            throw t;
        }
    }

    protected void cleanupStaleLocks(InvocationContext ctx) throws Throwable {
        super.cleanupStaleLocks(ctx);
        TransactionEntry entry = ctx.getTransactionEntry();
        if (entry != null) {
            ((OptimisticTransactionEntry)entry).getTransactionWorkSpace().clearNodes();
        }
    }

    protected TransactionEntry createNewTransactionEntry(Transaction tx) throws Exception {
        return new OptimisticTransactionEntry(tx);
    }

    private class ModificationsReplayVisitor
    extends AbstractVisitor {
        private ModificationsReplayVisitor() {
        }

        public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            Object result = OptimisticTxInterceptor.this.invokeNextInterceptor(ctx, command);
            OptimisticTxInterceptor.this.assertTxIsStillValid(ctx.getTransaction());
            return result;
        }

        public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
            return this.handleDataVersionCommand(ctx, command);
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.handleDataVersionCommand(ctx, command);
        }

        public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
            return this.handleDataVersionCommand(ctx, command);
        }

        public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
            return this.handleDataVersionCommand(ctx, command);
        }

        public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
            return this.handleDataVersionCommand(ctx, command);
        }

        private Object handleDataVersionCommand(InvocationContext ctx, VersionedDataCommand command) throws Throwable {
            Object retval;
            Option originalOption = ctx.getOptionOverrides();
            if (command.isVersioned()) {
                Option option = new Option();
                option.setDataVersion(command.getDataVersion());
                ctx.setOptionOverrides(option);
            }
            try {
                retval = OptimisticTxInterceptor.this.invokeNextInterceptor(ctx, command);
                OptimisticTxInterceptor.this.assertTxIsStillValid(ctx.getTransaction());
            }
            catch (Throwable t) {
                OptimisticTxInterceptor.this.log.error((Object)"method invocation failed", t);
                throw t;
            }
            finally {
                ctx.setOptionOverrides(originalOption);
            }
            return retval;
        }
    }
}

