/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.Collections;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.LRUConfiguration;
import org.jboss.cache.eviction.NullEvictionPolicy;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class EvictionOfBuddyBackupsTest
extends BuddyReplicationTestsBase {
    private CacheSPI cache1;
    private CacheSPI cache2;
    private Fqn fqn = Fqn.fromString((String)"/a/b/c");

    @BeforeTest
    public void setUp() throws Exception {
        this.cache1 = this.createCache(1, null, true, false);
        this.cache1.getConfiguration().setEvictionConfig(this.getEvictionConfig());
        this.cache1.start();
        this.cache2 = (CacheSPI)new DefaultCacheFactory().createCache(this.cache1.getConfiguration().clone());
        TestingUtil.blockUntilViewsReceived(60000L, new Cache[]{this.cache1, this.cache2});
    }

    @AfterTest
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache1, this.cache2});
    }

    private EvictionConfig getEvictionConfig() {
        EvictionConfig c = new EvictionConfig();
        c.setDefaultEvictionPolicyClass(NullEvictionPolicy.class.getName());
        c.setWakeupIntervalSeconds(1);
        LRUConfiguration epc = new LRUConfiguration();
        epc.setMaxAgeSeconds(1);
        epc.setTimeToLiveSeconds(1);
        EvictionRegionConfig erc = new EvictionRegionConfig(this.fqn, (EvictionPolicyConfig)epc);
        c.setEvictionRegionConfigs(Collections.singletonList(erc));
        return c;
    }

    public void testEvictionOfBackupRegions() throws Exception {
        this.cache1.put(this.fqn, (Object)"k", (Object)"v");
        assert (this.cache1.peek(this.fqn, false, false) != null) : "Node should exist";
        assert (this.cache2.peek(this.fqnTransformer.getBackupFqn(this.cache1.getLocalAddress(), this.fqn), false, false) != null) : "Node should exist on backup";
        TestingUtil.sleepThread(2000L);
        assert (this.cache1.peek(this.fqn, false, false) == null) : "Node should have evicted";
        assert (this.cache2.peek(this.fqnTransformer.getBackupFqn(this.cache1.getLocalAddress(), this.fqn), false, false) == null) : "Node should have evicted on backup";
    }
}

