/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.optimistic.TestListener;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class OptimisticCreateIfNotExistsInterceptorTest
extends AbstractOptimisticTestCase {
    protected TransactionManager txManager;
    protected Transaction tx;
    protected GlobalTransaction gtx;
    protected TransactionTable table;
    protected OptimisticTransactionEntry entry;
    protected TransactionWorkspace workspace;

    protected void setupTransactionsInInvocationCtx(CacheSPI cache) throws Exception {
        this.txManager = DummyTransactionManager.getInstance();
        this.txManager.begin();
        this.table = cache.getTransactionTable();
        this.gtx = cache.getCurrentTransaction();
        this.tx = this.txManager.getTransaction();
        this.entry = (OptimisticTransactionEntry)this.table.get(this.gtx);
        this.workspace = this.entry.getTransactionWorkSpace();
        this.setupTransactions(cache, this.tx);
    }

    public void testNodeCreation() throws Exception {
        TestListener listener = new TestListener();
        CacheSPI<Object, Object> cache = this.createCacheWithListener(listener);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        MockInterceptor dummy = new MockInterceptor();
        interceptor.setNext((CommandInterceptor)dummy);
        TestingUtil.replaceInterceptorChain(cache, (CommandInterceptor)interceptor);
        this.setupTransactionsInInvocationCtx(cache);
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertEquals((int)3, (int)this.workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)this.workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)this.workspace.getNode(Fqn.fromString((String)"/one/")));
        AssertJUnit.assertEquals(null, (Object)this.workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertTrue((boolean)this.entry.getLocks().isEmpty());
        AssertJUnit.assertTrue((!cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(PutKeyValueCommand.class, dummy.getCalledCommandClass());
        this.txManager.commit();
        cache.stop();
    }

    public void testInvalidTransaction() throws Exception {
        TestListener listener = new TestListener();
        CacheSPI<Object, Object> cache = this.createCacheWithListener(listener);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        MockInterceptor dummy = new MockInterceptor();
        interceptor.setNext((CommandInterceptor)dummy);
        TestingUtil.replaceInterceptorChain(cache, (CommandInterceptor)interceptor);
        this.setupTransactionsInInvocationCtx(cache);
        SamplePojo pojo = new SamplePojo(21, "test");
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        AssertJUnit.assertEquals((int)3, (int)this.workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)this.workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)this.workspace.getNode(Fqn.fromString((String)"/one/")));
        AssertJUnit.assertEquals(null, (Object)this.workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertTrue((boolean)this.entry.getLocks().isEmpty());
        AssertJUnit.assertTrue((!cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(PutKeyValueCommand.class, dummy.getCalledCommandClass());
        this.txManager.commit();
        cache.getInvocationContext().setGlobalTransaction(null);
        cache.getInvocationContext().setTransaction(null);
        cache.getInvocationContext().setTransactionEntry(null);
        try {
            cache.put("/one/two/three", (Object)"key1", (Object)pojo);
            AssertJUnit.assertTrue((String)"Should never be reched", (boolean)false);
        }
        catch (Throwable t) {
            AssertJUnit.assertTrue((boolean)true);
        }
        cache.stop();
    }

    public void testMultiplePut() throws Exception {
        TestListener listener = new TestListener();
        CacheSPI<Object, Object> cache = this.createCacheWithListener(listener);
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        MockInterceptor dummy = new MockInterceptor();
        interceptor.setNext((CommandInterceptor)dummy);
        TestingUtil.replaceInterceptorChain(cache, (CommandInterceptor)interceptor);
        SamplePojo pojo = new SamplePojo(21, "test");
        this.setupTransactionsInInvocationCtx(cache);
        cache.put("/one/two", (Object)"key1", (Object)pojo);
        cache.put("/one/two", (Object)"key2", (Object)pojo);
        AssertJUnit.assertEquals((int)3, (int)this.workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)this.workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertNotNull((Object)this.workspace.getNode(Fqn.fromString((String)"/one/")));
        AssertJUnit.assertEquals(null, (Object)this.workspace.getNode(Fqn.fromString((String)"/one/two")).get((Object)"key1"));
        AssertJUnit.assertTrue((boolean)this.entry.getLocks().isEmpty());
        AssertJUnit.assertTrue((!cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(PutKeyValueCommand.class, dummy.getCalledCommandClass());
        this.txManager.commit();
        cache.stop();
    }
}

