/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.pojo.test;


/**
 * Test class for PojoCache.
 *
 * @version $Revision: 6554 $
 *          <p>Below is the annotation that signifies this class is "prepared" under JBossAop. This is used in
 *          conjunction with a special jboss-aop.xml (supplied by JBossCache). In addition, this is JDK1.4 style,
 *          so a annoc Ant build target is needed to pre-compile it.</p>
 *          <p>To use this approach, just apply this line to your pojo and run annoc (and possibly aopc).</p>
 */
// We are using JDK1.5 annotation.
@org.jboss.cache.pojo.annotation.Replicable
public class Address
{
   private String street = null;
   private String city = null;
   private int zip = 0;

   public String getStreet()
   {
      return street;
   }

   public void setStreet(String street)
   {
      this.street = street;
   }

   public String getCity()
   {
      return city;
   }

   public void setCity(String city)
   {
      this.city = city;
   }

   public int getZip()
   {
      return zip;
   }

   public void setZip(int zip)
   {
      this.zip = zip;
   }

   public String toString()
   {
      return "street=" + getStreet() + ", city=" + getCity() + ", zip=" + getZip();
   }
   
   public int hashCode()
   {
      return 1241 * zip + 37 * (city != null ? city.hashCode() : 0)
                        + 37 * (street != null ? street.hashCode() : 0);
   }
   
   private boolean equals(Object o1, Object o2)
   {
      return o1 == o2 || (o1 != null && o1.equals(o2));
   }

   public boolean equals(Object o)
   {
      if (!(o instanceof Address))
         return false;

      Address addr = (Address)o;
      return addr.zip == zip && equals(addr.city, city) && equals(addr.street, street);
   }
   
//    public Object writeReplace() {
//	return this;
//    }
}
