/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.cache.pojo.test;

import org.jboss.cache.pojo.annotation.Replicable;

/**
 * Contains two fields referring to the same object reference
 *
 * @author Jason T. Greene
 */
@Replicable
public class DoubleRef
{
   private Student one = new Student();
   private Student two = one;
  
   public Student getOne()
   {
      return one;
   }
   
   public void setOne(Student one)
   {
      this.one = one;
   }
   
   public Student getTwo()
   {
      return two;
   }
   
   public void setTwo(Student two)
   {
      this.two = two;
   }
}
