/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.pojo.test;

import org.jboss.cache.pojo.annotation.Serializable;
import org.jboss.cache.pojo.annotation.Transient;

/**
 * Test class for PojoCache using annotation. This object consists of sub-objects
 * that has special annotation.
 *
 * @version $Revision: 6554 $
 */
@org.jboss.cache.pojo.annotation.Replicable
public class Gadget
{
   String name;
   @Transient
   Resource resource;
   @Serializable
   SpecialAddress addr;

   public String getName()
   {
      return name;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   public Resource getResource()
   {
      return resource;
   }

   public void setResource(Resource resource)
   {
      this.resource = resource;
   }

   public SpecialAddress getAddr()
   {
      return addr;
   }

   public void setAddr(SpecialAddress addr)
   {
      this.addr = addr;
   }

   public String toString()
   {
      return "name=" + getName() + ", resource=" + getResource() + ", SepcialAddress: " + getAddr();
   }
}
