/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.BlockEvent;
import org.jgroups.Channel;
import org.jgroups.ExtendedReceiver;
import org.jgroups.GetStateEvent;
import org.jgroups.JChannel;
import org.jgroups.JChannelFactory;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.SetStateEvent;
import org.jgroups.UnblockEvent;
import org.jgroups.View;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.mux.MuxChannel;
import org.jgroups.stack.GossipRouter;
import org.jgroups.util.Util;

public class ChannelTestBase
extends TestCase {
    protected static final Random RANDOM = new Random();
    private static final int LETTER_A = 64;
    protected static final String DEFAULT_MUX_FACTORY_COUNT = "4";
    protected static String CHANNEL_CONFIG = "udp.xml";
    protected static String MUX_CHANNEL_CONFIG = "stacks.xml";
    protected static String MUX_CHANNEL_CONFIG_STACK_NAME = "udp";
    protected int active_threads = 0;
    protected JChannelFactory[] muxFactory = null;
    protected String thread_dump = null;
    protected int currentChannelGeneratedName = 64;
    private static final int ROUTER_PORT = 12001;
    private static final String BIND_ADDR = "127.0.0.1";
    GossipRouter router = null;
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public ChannelTestBase() {
    }

    public ChannelTestBase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        MUX_CHANNEL_CONFIG = System.getProperty("mux.conf", MUX_CHANNEL_CONFIG);
        MUX_CHANNEL_CONFIG_STACK_NAME = System.getProperty("mux.conf.stack", MUX_CHANNEL_CONFIG_STACK_NAME);
        CHANNEL_CONFIG = System.getProperty("channel.conf", CHANNEL_CONFIG);
        this.currentChannelGeneratedName = 64;
        if (ChannelTestBase.isTunnelUsed()) {
            this.router = new GossipRouter(12001, BIND_ADDR);
            this.router.start();
        }
        if (ChannelTestBase.isMuxChannelUsed()) {
            this.muxFactory = new JChannelFactory[this.getMuxFactoryCount()];
            for (int i = 0; i < this.muxFactory.length; ++i) {
                this.muxFactory[i] = new JChannelFactory();
                this.muxFactory[i].setMultiplexerConfig(MUX_CHANNEL_CONFIG);
            }
        }
        if (ChannelTestBase.shouldCompareThreadCount()) {
            this.active_threads = Thread.activeCount();
            this.thread_dump = "active threads before (" + this.active_threads + "):\n" + Util.activeThreads();
        }
    }

    protected static boolean isTunnelUsed() {
        String channelConf = System.getProperty("channel.conf", "");
        String channelFlushConf = System.getProperty("channel.conf.flush", "");
        return channelConf.contains("tunnel") || channelFlushConf.contains("tunnel");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (ChannelTestBase.isMuxChannelUsed()) {
            for (int i = 0; i < this.muxFactory.length; ++i) {
                this.muxFactory[i].destroy();
            }
        }
        if (this.router != null) {
            this.router.stop();
            Util.sleep(100L);
        }
        if (ChannelTestBase.shouldCompareThreadCount()) {
            Util.sleep(20L);
            int current_active_threads = Thread.activeCount();
            String msg = "";
            if (this.active_threads != current_active_threads) {
                System.out.println(this.thread_dump);
                System.out.println("active threads after (" + current_active_threads + "):\n" + Util.activeThreads());
                msg = "active threads:\n" + Util.dumpThreads();
            }
            ChannelTestBase.assertEquals((String)msg, (int)this.active_threads, (int)current_active_threads);
        }
    }

    protected String[] createMuxApplicationNames(int muxApplicationstPerChannelCount) {
        return this.createMuxApplicationNames(muxApplicationstPerChannelCount, this.getMuxFactoryCount());
    }

    protected String[] createMuxApplicationNames(int muxApplicationstPerChannelCount, int muxFactoryCount) {
        if (muxFactoryCount > this.getMuxFactoryCount()) {
            throw new IllegalArgumentException("Parameter muxFactoryCount hs to be less than or equal to getMuxFactoryCount()");
        }
        int startLetter = 64;
        String[] names = null;
        int totalMuxAppCount = muxFactoryCount * muxApplicationstPerChannelCount;
        names = new String[totalMuxAppCount];
        boolean pickNextLetter = false;
        for (int i = 0; i < totalMuxAppCount; ++i) {
            boolean bl = pickNextLetter = i % muxFactoryCount == 0;
            if (pickNextLetter) {
                ++startLetter;
            }
            names[i] = Character.toString((char)startLetter);
        }
        return names;
    }

    protected String getNextChannelName() {
        return Character.toString((char)(++this.currentChannelGeneratedName));
    }

    protected String[] createApplicationNames(int applicationCount) {
        String[] names = new String[applicationCount];
        for (int i = 0; i < applicationCount; ++i) {
            names[i] = this.getNextChannelName();
        }
        return names;
    }

    protected JChannel createChannel(Object id) throws Exception {
        return (JChannel)new DefaultChannelTestFactory().createChannel(id);
    }

    protected JChannel createChannel() throws Exception {
        return this.createChannel("A");
    }

    protected void checkEventStateTransferSequence(EventSequence receiver) {
        List<Object> events = receiver.getEvents();
        String eventString = "[" + receiver.getName() + ",events:" + events;
        this.log.info((Object)eventString);
        ChannelTestBase.assertNotNull(events);
        ChannelTestBase.assertTrue((events.size() > 1 ? 1 : 0) != 0);
        ChannelTestBase.assertTrue((String)("First event is not block but " + events.get(0)), (boolean)(events.get(0) instanceof BlockEvent));
        ChannelTestBase.assertTrue((String)("Last event not unblock but " + events.get(events.size() - 1)), (boolean)(events.get(events.size() - 1) instanceof UnblockEvent));
        int size = events.size();
        for (int i = 0; i < size; ++i) {
            Object o;
            Object event = events.get(i);
            if (event instanceof BlockEvent) {
                if (i + 1 < size) {
                    o = events.get(i + 1);
                    ChannelTestBase.assertTrue((String)("After Block should be state|unblock|view, but it is " + o.getClass() + ",events= " + eventString), (o instanceof SetStateEvent || o instanceof GetStateEvent || o instanceof UnblockEvent || o instanceof View ? 1 : 0) != 0);
                }
                if (i <= 0) continue;
                o = events.get(i - 1);
                ChannelTestBase.assertTrue((String)("Before Block should be state or Unblock , but it is " + o.getClass() + ",events= " + eventString), (boolean)(o instanceof UnblockEvent));
                continue;
            }
            if (event instanceof SetStateEvent) {
                if (i + 1 < size) {
                    o = events.get(i + 1);
                    ChannelTestBase.assertTrue((String)("After setstate should be unblock , but it is " + o.getClass() + ",events= " + eventString), (boolean)(o instanceof UnblockEvent));
                }
                o = events.get(i - 1);
                ChannelTestBase.assertTrue((String)("Before setstate should be block|view, but it is " + o.getClass() + ",events= " + eventString), (o instanceof BlockEvent || o instanceof View ? 1 : 0) != 0);
                continue;
            }
            if (event instanceof GetStateEvent) {
                if (i + 1 < size) {
                    o = events.get(i + 1);
                    ChannelTestBase.assertTrue((String)("After getstate should be view/unblock/getstate , but it is " + o.getClass() + ",events= " + eventString), (o instanceof UnblockEvent || o instanceof View || o instanceof GetStateEvent ? 1 : 0) != 0);
                }
                o = events.get(i - 1);
                ChannelTestBase.assertTrue((String)("Before state should be block/view/getstate , but it is " + o.getClass() + ",events= " + eventString), (o instanceof BlockEvent || o instanceof View || o instanceof GetStateEvent ? 1 : 0) != 0);
                continue;
            }
            if (!(event instanceof UnblockEvent)) continue;
            if (i + 1 < size) {
                o = events.get(i + 1);
                ChannelTestBase.assertTrue((String)("After UnBlock should be Block , but it is " + o.getClass() + ",events= " + eventString), (boolean)(o instanceof BlockEvent));
            }
            if (i <= 0) continue;
            o = events.get(i - 1);
            ChannelTestBase.assertTrue((String)("Before UnBlock should be block|state|view , but it is " + o.getClass() + ",events= " + eventString), (o instanceof SetStateEvent || o instanceof GetStateEvent || o instanceof BlockEvent || o instanceof View ? 1 : 0) != 0);
        }
    }

    protected void checkEventSequence(PushChannelApplication receiver, boolean isMuxUsed) {
        List<Object> events = receiver.getEvents();
        String eventString = "[" + receiver.getName() + "|" + receiver.getLocalAddress() + ",events:" + events;
        this.log.info((Object)eventString);
        ChannelTestBase.assertNotNull(events);
        ChannelTestBase.assertTrue((events.size() > 1 ? 1 : 0) != 0);
        ChannelTestBase.assertTrue((String)("First event is not block but " + events.get(0)), (boolean)(events.get(0) instanceof BlockEvent));
        ChannelTestBase.assertTrue((String)("Last event not unblock but " + events.get(events.size() - 1)), (boolean)(events.get(events.size() - 1) instanceof UnblockEvent));
        int size = events.size();
        for (int i = 0; i < size; ++i) {
            Object ev;
            Object event = events.get(i);
            if (event instanceof BlockEvent) {
                if (i + 1 < size) {
                    ev = events.get(i + 1);
                    if (isMuxUsed) {
                        ChannelTestBase.assertTrue((String)("After Block should be View or Unblock but it is " + ev.getClass() + ",events= " + eventString), (ev instanceof View || ev instanceof UnblockEvent ? 1 : 0) != 0);
                    } else {
                        ChannelTestBase.assertTrue((String)("After Block should be View but it is " + ev.getClass() + ",events= " + eventString), (boolean)(ev instanceof View));
                    }
                }
                if (i <= 0) continue;
                ev = events.get(i - 1);
                ChannelTestBase.assertTrue((String)("Before Block should be Unblock but it is " + ev.getClass() + ",events= " + eventString), (boolean)(ev instanceof UnblockEvent));
                continue;
            }
            if (event instanceof View) {
                if (i + 1 < size) {
                    ev = events.get(i + 1);
                    ChannelTestBase.assertTrue((String)("After View should be Unblock but it is " + ev.getClass() + ",events= " + eventString), (boolean)(ev instanceof UnblockEvent));
                }
                ev = events.get(i - 1);
                ChannelTestBase.assertTrue((String)("Before View should be Block but it is " + ev.getClass() + ",events= " + eventString), (boolean)(ev instanceof BlockEvent));
                continue;
            }
            if (!(event instanceof UnblockEvent)) continue;
            if (i + 1 < size) {
                ev = events.get(i + 1);
                ChannelTestBase.assertTrue((String)("After UnBlock should be Block but it is " + ev.getClass() + ",events= " + eventString), (boolean)(ev instanceof BlockEvent));
            }
            ev = events.get(i - 1);
            if (isMuxUsed) {
                ChannelTestBase.assertTrue((String)("Before UnBlock should be View or Block but it is " + ev.getClass() + ",events= " + eventString), (ev instanceof View || ev instanceof BlockEvent ? 1 : 0) != 0);
                continue;
            }
            ChannelTestBase.assertTrue((String)("Before UnBlock should be View but it is " + ev.getClass() + ",events= " + eventString), (boolean)(ev instanceof View));
        }
    }

    protected static boolean isMuxChannelUsed() {
        return Boolean.valueOf(System.getProperty("mux.on", "false"));
    }

    protected static boolean shouldCompareThreadCount() {
        return Boolean.valueOf(System.getProperty("threadcount", "false"));
    }

    protected int getMuxFactoryCount() {
        return Integer.parseInt(System.getProperty("mux.factorycount", DEFAULT_MUX_FACTORY_COUNT));
    }

    protected boolean useBlocking() {
        return Boolean.valueOf(System.getProperty("useBlocking", "false"));
    }

    public static boolean areViewsComplete(MemberRetrievable[] channels, int memberCount) {
        for (int i = 0; i < memberCount; ++i) {
            if (ChannelTestBase.isViewComplete(channels[i], memberCount)) continue;
            return false;
        }
        return true;
    }

    public static void blockUntilViewsReceived(MemberRetrievable[] channels, long timeout) {
        ChannelTestBase.blockUntilViewsReceived(channels, channels.length, timeout);
    }

    public static void blockUntilViewsReceived(Collection channels, long timeout) {
        ChannelTestBase.blockUntilViewsReceived(channels, channels.size(), timeout);
    }

    public static void blockUntilViewsReceived(MemberRetrievable[] channels, int count, long timeout) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            Util.sleep(100L);
            if (!ChannelTestBase.areViewsComplete(channels, count)) continue;
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (MemberRetrievable c : channels) {
            sb.append(c.getLocalAddress() + ",view=" + c.getMembers() + "|");
        }
        throw new RuntimeException("timed out before caches had complete views. Views are " + sb.toString());
    }

    public static void blockUntilViewsReceived(Collection channels, int count, long timeout) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            Util.sleep(100L);
            if (!ChannelTestBase.areViewsComplete(channels.toArray(new MemberRetrievable[channels.size()]), count)) continue;
            return;
        }
        throw new RuntimeException("timed out before caches had complete views");
    }

    public static boolean isViewComplete(MemberRetrievable channel, int memberCount) {
        List members = channel.getMembers();
        if (members == null || memberCount > members.size()) {
            return false;
        }
        if (memberCount < members.size()) {
            StringBuilder sb = new StringBuilder("Channel at address ");
            sb.append(channel.getLocalAddress());
            sb.append(" had ");
            sb.append(members.size());
            sb.append(" members; expecting ");
            sb.append(memberCount);
            sb.append(". Members were (");
            for (int j = 0; j < members.size(); ++j) {
                if (j > 0) {
                    sb.append(", ");
                }
                sb.append(members.get(j));
            }
            sb.append(')');
            throw new IllegalStateException(sb.toString());
        }
        return true;
    }

    public static void sleepRandom(int minTime, int maxTime) {
        int nextInt = RANDOM.nextInt(maxTime);
        if (nextInt < minTime) {
            nextInt = minTime;
        }
        Util.sleep(nextInt);
    }

    protected static interface MemberRetrievable {
        public List getMembers();

        public Address getLocalAddress();
    }

    protected abstract class PushChannelApplicationWithSemaphore
    extends PushChannelApplication {
        protected Semaphore semaphore;

        public PushChannelApplicationWithSemaphore(String name, ChannelTestFactory factory, Semaphore semaphore, boolean useDispatcher) throws Exception {
            super(name, factory, useDispatcher);
            this.semaphore = semaphore;
        }

        protected PushChannelApplicationWithSemaphore(String name, Semaphore semaphore) throws Exception {
            this(name, semaphore, false);
        }

        protected PushChannelApplicationWithSemaphore(String name, Semaphore semaphore, boolean useDispatcher) throws Exception {
            this(name, channelTestBase.new DefaultChannelTestFactory(), semaphore, useDispatcher);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean acquired = false;
            try {
                acquired = this.semaphore.tryAcquire(60000L, TimeUnit.MILLISECONDS);
                if (!acquired) {
                    throw new Exception(this.name + " cannot acquire semaphore");
                }
                this.useChannel();
            }
            catch (Exception e) {
                ChannelTestBase.this.log.error((Object)(this.name + ": " + e.getLocalizedMessage()), (Throwable)e);
                this.exception = e;
            }
            finally {
                if (acquired) {
                    this.semaphore.release();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class PushChannelApplication
    extends ChannelApplication
    implements ExtendedReceiver {
        RpcDispatcher dispatcher;
        List<Object> events;

        public PushChannelApplication(String name) throws Exception {
            this(name, false);
        }

        public PushChannelApplication(String name, boolean useDispatcher) throws Exception {
            this(name, channelTestBase.new DefaultChannelTestFactory(), useDispatcher);
        }

        public PushChannelApplication(String name, ChannelTestFactory factory, boolean useDispatcher) throws Exception {
            super(name, factory);
            this.events = Collections.synchronizedList(new LinkedList());
            if (useDispatcher) {
                this.dispatcher = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
            } else {
                this.channel.setReceiver(this);
            }
        }

        @Override
        public List<Object> getEvents() {
            return this.events;
        }

        public RpcDispatcher getDispatcher() {
            return this.dispatcher;
        }

        public boolean hasDispatcher() {
            return this.dispatcher != null;
        }

        @Override
        public void block() {
            this.events.add(new BlockEvent());
            ChannelTestBase.this.log.debug((Object)("Channel " + this.getLocalAddress() + "[" + this.getName() + "] in blocking"));
        }

        @Override
        public byte[] getState() {
            this.events.add(new GetStateEvent(null, null));
            ChannelTestBase.this.log.debug((Object)("Channel getState " + this.getLocalAddress() + "[" + this.getName() + "] "));
            return null;
        }

        @Override
        public void getState(OutputStream ostream) {
            this.events.add(new GetStateEvent(null, null));
            ChannelTestBase.this.log.debug((Object)("Channel getState " + this.getLocalAddress() + "[" + this.getName() + "]"));
        }

        @Override
        public byte[] getState(String state_id) {
            this.events.add(new GetStateEvent(null, state_id));
            ChannelTestBase.this.log.debug((Object)("Channel getState " + this.getLocalAddress() + "[" + this.getName() + " state id =" + state_id));
            return null;
        }

        @Override
        public void getState(String state_id, OutputStream ostream) {
            this.events.add(new GetStateEvent(null, state_id));
            ChannelTestBase.this.log.debug((Object)("Channel getState " + this.getLocalAddress() + "[" + this.getName() + "] state id =" + state_id));
        }

        @Override
        public void receive(Message msg) {
        }

        @Override
        public void setState(byte[] state) {
            this.events.add(new SetStateEvent(null, null));
            ChannelTestBase.this.log.debug((Object)("Channel setState " + this.getLocalAddress() + "[" + this.getName() + "] "));
        }

        @Override
        public void setState(InputStream istream) {
            this.events.add(new SetStateEvent(null, null));
            ChannelTestBase.this.log.debug((Object)("Channel setState " + this.getLocalAddress() + "[" + this.getName() + "]"));
        }

        @Override
        public void setState(String state_id, byte[] state) {
            this.events.add(new SetStateEvent(null, null));
            ChannelTestBase.this.log.debug((Object)("Channel setState " + this.getLocalAddress() + "[" + this.getName() + "] state id =" + state_id + ", state size is " + state.length));
        }

        @Override
        public void setState(String state_id, InputStream istream) {
            this.events.add(new SetStateEvent(null, null));
            ChannelTestBase.this.log.debug((Object)("Channel setState " + this.getLocalAddress() + "[" + this.getName() + "] state id " + state_id));
        }

        @Override
        public void suspect(Address suspected_mbr) {
            ChannelTestBase.this.log.debug((Object)("Channel " + this.getLocalAddress() + "[" + this.getName() + "] suspecting " + suspected_mbr));
        }

        @Override
        public void unblock() {
            this.events.add(new UnblockEvent());
            ChannelTestBase.this.log.debug((Object)("Channel " + this.getLocalAddress() + "[" + this.getName() + "] unblocking"));
        }

        @Override
        public void viewAccepted(View new_view) {
            this.events.add(new_view);
            ChannelTestBase.this.log.info((Object)("Channel " + this.getLocalAddress() + "[" + this.getName() + "] accepted view " + new_view));
        }
    }

    protected abstract class ChannelApplication
    implements EventSequence,
    Runnable,
    MemberRetrievable {
        protected Channel channel;
        protected Thread thread;
        protected Throwable exception;
        protected String name;

        public ChannelApplication(String name) throws Exception {
            ChannelTestBase.this.createChannel(name);
        }

        public ChannelApplication(String name, ChannelTestFactory factory) throws Exception {
            this.name = name;
            this.channel = factory.createChannel(name);
        }

        protected abstract void useChannel() throws Exception;

        public void run() {
            try {
                this.useChannel();
            }
            catch (Exception e) {
                ChannelTestBase.this.log.error((Object)(this.name + ": " + e.getLocalizedMessage()), (Throwable)e);
                this.exception = e;
            }
        }

        public List getMembers() {
            Vector<Address> result = null;
            View v = this.channel.getView();
            if (v != null) {
                result = v.getMembers();
            }
            return result;
        }

        public boolean isUsingMuxChannel() {
            return this.channel instanceof MuxChannel;
        }

        public Address getLocalAddress() {
            return this.channel.getLocalAddress();
        }

        public void start() {
            boolean connected;
            this.thread = new Thread((Runnable)this, this.getName());
            this.thread.start();
            Address a = this.getLocalAddress();
            boolean bl = connected = a != null;
            if (connected) {
                ChannelTestBase.this.log.info((Object)("Thread for channel " + a + "[" + this.getName() + "] started"));
            } else {
                ChannelTestBase.this.log.info((Object)("Thread for channel [" + this.getName() + "] started"));
            }
        }

        public void setChannel(Channel ch) {
            this.channel = ch;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public String getName() {
            return this.name;
        }

        public void cleanup() {
            Address a;
            boolean connected;
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
            }
            boolean bl = connected = (a = this.getLocalAddress()) != null;
            if (connected) {
                ChannelTestBase.this.log.info((Object)("Closing channel " + a + "[" + this.getName() + "]"));
            } else {
                ChannelTestBase.this.log.info((Object)("Closing channel [" + this.getName() + "]"));
            }
            try {
                this.channel.close();
                ChannelTestBase.this.log.info((Object)("Closed channel " + a + "[" + this.getName() + "]"));
            }
            catch (Throwable t) {
                ChannelTestBase.this.log.warn((Object)("Got exception while closing channel " + a + "[" + this.getName() + "]"));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface EventSequence {
        public List<Object> getEvents();

        public String getName();
    }

    protected static interface ChannelTestFactory {
        public Channel createChannel(Object var1) throws Exception;
    }

    public class NextAvailableMuxChannelTestFactory
    implements ChannelTestFactory {
        public Channel createChannel(Object id) throws Exception {
            return ChannelTestBase.this.createChannel(id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DefaultChannelTestFactory
    implements ChannelTestFactory {
        protected DefaultChannelTestFactory() {
        }

        protected JChannel createChannel(String configFile, boolean useBlocking) throws Exception {
            HashMap<Integer, Object> channelOptions = new HashMap<Integer, Object>();
            channelOptions.put(0, useBlocking);
            return this.createChannel(configFile, channelOptions);
        }

        protected JChannel createChannel(String configFile, Map<Integer, Object> channelOptions) throws Exception {
            JChannel ch = null;
            ChannelTestBase.this.log.info((Object)("Using configuration file " + configFile));
            ch = new JChannel(configFile);
            for (Map.Entry<Integer, Object> entry : channelOptions.entrySet()) {
                Integer key = entry.getKey();
                Object value = entry.getValue();
                ch.setOpt(key, value);
            }
            return ch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Channel createChannel(Object id) throws Exception {
            JChannel c = null;
            if (ChannelTestBase.isMuxChannelUsed()) {
                JChannelFactory[] jChannelFactoryArray = ChannelTestBase.this.muxFactory;
                synchronized (ChannelTestBase.this.muxFactory) {
                    ChannelTestBase.this.log.info((Object)("Using configuration file " + MUX_CHANNEL_CONFIG + ", stack is " + MUX_CHANNEL_CONFIG_STACK_NAME));
                    for (int i = 0; i < ChannelTestBase.this.muxFactory.length; ++i) {
                        if (ChannelTestBase.this.muxFactory[i].hasMuxChannel(MUX_CHANNEL_CONFIG_STACK_NAME, id.toString())) continue;
                        c = (JChannel)ChannelTestBase.this.muxFactory[i].createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, id.toString());
                        if (ChannelTestBase.this.useBlocking()) {
                            c.setOpt(0, Boolean.TRUE);
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return c;
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    throw new Exception("Cannot create mux channel with id " + id + " since all currently used channels have already registered service with that id");
                }
            }
            c = this.createChannel(CHANNEL_CONFIG, ChannelTestBase.this.useBlocking());
            return c;
        }
    }
}

