/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import java.util.HashMap;
import org.easymock.EasyMock;
import org.jboss.cache.CacheException;
import org.jboss.cache.commands.write.AbstractVersionedDataCommand;
import org.jboss.cache.commands.write.AbstractVersionedDataCommandTest;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class PutKeyValueCommandTest
extends AbstractVersionedDataCommandTest {
    PutKeyValueCommand command;

    public AbstractVersionedDataCommand moreSetUp() {
        this.command = new PutForExternalReadCommand(this.globalTransaction, this.fqn, (Object)"k", (Object)"v");
        return this.command;
    }

    public void testInexistentNode() {
        EasyMock.expect((Object)this.container.peekStrict(this.globalTransaction, this.fqn, false)).andThrow((Throwable)new CacheException());
        this.control.replay();
        try {
            this.command.perform(this.ctx);
            assert (false) : "exception should have been thrown as data does not exists.";
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.control.verify();
    }

    public void testAddNewData() {
        this.nodes.adfNode.put("existingKey", "existingValue");
        EasyMock.expect((Object)this.container.peekStrict(this.globalTransaction, this.fqn, false)).andReturn((Object)this.nodes.adfNode);
        EasyMock.expect((Object)this.notifier.shouldNotifyOnNodeModified()).andReturn((Object)true);
        this.notifier.notifyNodeModified(this.fqn, true, NodeModifiedEvent.ModificationType.PUT_DATA, this.nodes.adfNode.getDataDirect(), this.ctx);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("k", "v");
        EasyMock.expect((Object)this.notifier.shouldNotifyOnNodeModified()).andReturn((Object)true);
        this.notifier.notifyNodeModified(this.fqn, false, NodeModifiedEvent.ModificationType.PUT_DATA, expected, this.ctx);
        this.control.replay();
        assert (null == this.command.perform(this.ctx)) : "no pre existing value";
        assert (this.nodes.adfNode.getData().size() == 2);
        assert ("v".equals(this.nodes.adfNode.getData().get("k")));
        assert ("existingValue".equals(this.nodes.adfNode.getData().get("existingKey")));
        this.control.verify();
        this.control.reset();
        EasyMock.expect((Object)this.container.peek(this.fqn, false, false)).andReturn((Object)this.nodes.adfNode);
        this.control.replay();
        this.command.rollback();
        assert (this.nodes.adfNode.getData().size() == 1);
        assert ("existingValue".equals(this.nodes.adfNode.getData().get("existingKey")));
        this.control.verify();
    }

    public void testOverWriteData() {
        this.nodes.adfNode.put("k", "oldValue");
        EasyMock.expect((Object)this.container.peekStrict(this.globalTransaction, this.fqn, false)).andReturn((Object)this.nodes.adfNode);
        EasyMock.expect((Object)this.notifier.shouldNotifyOnNodeModified()).andReturn((Object)true);
        this.notifier.notifyNodeModified(this.fqn, true, NodeModifiedEvent.ModificationType.PUT_DATA, this.nodes.adfNode.getDataDirect(), this.ctx);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("k", "v");
        EasyMock.expect((Object)this.notifier.shouldNotifyOnNodeModified()).andReturn((Object)true);
        this.notifier.notifyNodeModified(this.fqn, false, NodeModifiedEvent.ModificationType.PUT_DATA, expected, this.ctx);
        this.control.replay();
        assert ("oldValue".equals(this.command.perform(this.ctx))) : "no pre existing value";
        assert (this.nodes.adfNode.getData().size() == 1);
        assert ("v".equals(this.nodes.adfNode.getData().get("k")));
        this.control.verify();
        this.control.reset();
        EasyMock.expect((Object)this.container.peek(this.fqn, false, false)).andReturn((Object)this.nodes.adfNode);
        this.control.replay();
        this.command.rollback();
        assert (this.nodes.adfNode.getData().size() == 1);
        assert ("oldValue".equals(this.nodes.adfNode.getData().get("k")));
        this.control.verify();
    }
}

