/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.AbstractDelegatingCacheLoader;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderTestsBase;
import org.jboss.cache.loader.LocalDelegatingCacheLoader;
import org.jboss.cache.loader.LocalDelegatingCacheLoaderConfig;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class LocalDelegatingCacheLoaderTest
extends CacheLoaderTestsBase {
    CacheSPI delegating_cache;

    protected void configureCache() throws Exception {
        this.delegating_cache = (CacheSPI)new DefaultCacheFactory().createCache(false);
        this.delegating_cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.delegating_cache.create();
        this.delegating_cache.start();
        LocalDelegatingCacheLoaderConfig cfg = new LocalDelegatingCacheLoaderConfig();
        cfg.setDelegate((Cache)this.delegating_cache);
        cfg.setAsync(false);
        cfg.setFetchPersistentState(false);
        CacheLoaderConfig cacheLoaderConfig = new CacheLoaderConfig();
        cacheLoaderConfig.addIndividualCacheLoaderConfig((CacheLoaderConfig.IndividualCacheLoaderConfig)cfg);
        this.cache.getConfiguration().setCacheLoaderConfig(cacheLoaderConfig);
    }

    protected void postConfigure() {
        CacheLoader ldr = this.loader;
        LocalDelegatingCacheLoader ldcl = null;
        do {
            if (ldr instanceof LocalDelegatingCacheLoader) {
                ldcl = (LocalDelegatingCacheLoader)ldr;
                continue;
            }
            if (!(ldr instanceof AbstractDelegatingCacheLoader)) break;
            ldr = ((AbstractDelegatingCacheLoader)ldr).getCacheLoader();
        } while (ldcl == null);
        ldcl.setDelegateCache(this.delegating_cache);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        super.tearDown();
        this.delegating_cache.stop();
        this.delegating_cache.destroy();
    }

    @Test(groups={"functional"}, enabled=false)
    public void testLoadAndStore() throws Exception {
    }

    public void testPartialLoadAndStore() {
    }

    public void testBuddyBackupStore() {
    }

    public void testCacheLoaderThreadSafety() {
    }

    public void testCacheLoaderThreadSafetyMultipleFqns() {
    }
}

