/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.LRUConfiguration;
import org.jboss.cache.eviction.LRUPolicy;
import org.jboss.cache.loader.JDBCCacheLoaderConfig;
import org.jboss.cache.marshall.FooClassLoader;
import org.jboss.cache.marshall.RegionBasedMarshallingTestBase;
import org.jboss.cache.marshall.SelectedClassnameClassLoader;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class CacheLoaderMarshallingJDBCTest
extends RegionBasedMarshallingTestBase {
    private static final String className = "org.jboss.cache.marshall.MyUUID";
    private Cache<Object, Object> cache;
    private Fqn fqn = Fqn.fromString((String)"/a");

    @BeforeMethod(alwaysRun=true)
    protected void setUp() throws Exception {
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @AfterMethod(alwaysRun=true)
    protected void tearDown() {
        this.resetContextClassLoader();
        TestingUtil.killCaches(this.cache);
    }

    protected ClassLoader getClassLoader() {
        String[] includesClasses = new String[]{className};
        String[] excludesClasses = new String[]{};
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return new SelectedClassnameClassLoader(includesClasses, excludesClasses, cl);
    }

    public void testCacheLoaderMarshalling() throws Exception {
        this.cacheLoaderMarshallingTest(false);
    }

    public void testCacheLoaderRegionBasedMarshalling() throws Exception {
        this.cacheLoaderMarshallingTest(true);
    }

    private void cacheLoaderMarshallingTest(boolean useRegionBased) throws Exception {
        this.cache = this.createCache(useRegionBased);
        this.cache.start();
        FooClassLoader loader = new FooClassLoader(this.originalClassLoader);
        if (useRegionBased) {
            Region r = this.cache.getRegion(Fqn.ROOT, true);
            r.registerContextClassLoader((ClassLoader)loader);
            r.activate();
        }
        Class clazz = loader.loadFoo();
        Object obj = clazz.newInstance();
        Thread.currentThread().setContextClassLoader(loader);
        this.cache.put(this.fqn, (Object)"key", obj);
        this.resetContextClassLoader();
        this.cache.evict(this.fqn);
        Thread.currentThread().setContextClassLoader(loader);
        AssertJUnit.assertEquals(obj, (Object)this.cache.get(this.fqn, (Object)"key"));
    }

    private Cache createCache(boolean useRegionBased) throws Exception {
        Properties prop = this.getProperties();
        prop.setProperty("cache.jdbc.table.drop", "true");
        Cache cache = new DefaultCacheFactory().createCache(false);
        Configuration config = cache.getConfiguration();
        config.setUseRegionBasedMarshalling(useRegionBased);
        config.setInactiveOnStartup(useRegionBased);
        EvictionConfig ec = new EvictionConfig();
        ec.setDefaultEvictionPolicyClass(LRUPolicy.class.getName());
        ec.setWakeupIntervalSeconds(1000);
        EvictionRegionConfig erc = new EvictionRegionConfig();
        erc.setRegionFqn(Fqn.ROOT);
        erc.setRegionName("_default_");
        LRUConfiguration epc = new LRUConfiguration();
        epc.setMaxNodes(1000);
        epc.setTimeToLiveSeconds(1000);
        erc.setEvictionPolicyConfig((EvictionPolicyConfig)epc);
        ArrayList<EvictionRegionConfig> ercs = new ArrayList<EvictionRegionConfig>();
        ercs.add(erc);
        ec.setEvictionRegionConfigs(ercs);
        config.setEvictionConfig(ec);
        CacheLoaderConfig clc = new CacheLoaderConfig();
        clc.setPassivation(true);
        clc.setShared(false);
        JDBCCacheLoaderConfig jdbc_clc = new JDBCCacheLoaderConfig();
        jdbc_clc.setProperties(prop);
        clc.setIndividualCacheLoaderConfigs(Collections.singletonList(jdbc_clc));
        config.setCacheLoaderConfig(clc);
        return cache;
    }

    private Properties getProperties() throws Exception {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getClassLoader().getResourceAsStream("cache-jdbc.properties"));
            return properties;
        }
        catch (Exception e) {
            throw new Exception("Error loading jdbc properties ", e);
        }
    }
}

