/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;
import org.jboss.cache.transaction.TransactionManagerLookup;
import org.jboss.cache.transaction.TransactionTable;

public class NotifyingTransactionManager
extends DummyTransactionManager
implements TransactionManagerLookup {
    private static final long serialVersionUID = -2994163352889758708L;
    private Notification notification;
    private CacheSPI cache;

    public void commit() throws HeuristicMixedException, SystemException, HeuristicRollbackException, RollbackException {
        this.notifyListeners();
        super.commit();
    }

    public void rollback() throws SystemException {
        this.notifyListeners();
        super.rollback();
    }

    private void notifyListeners() {
        try {
            log.debug((Object)"Calling notification.notify()");
            TransactionTable txTable = this.cache.getTransactionTable();
            Transaction tx = this.getTransaction();
            GlobalTransaction gtx = txTable.get(tx);
            this.notification.notify(tx, txTable.get(gtx));
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    public TransactionManager getTransactionManager() throws Exception {
        return this;
    }

    public CacheSPI getCache() {
        return this.cache;
    }

    public void setCache(CacheSPI cache) {
        this.cache = cache;
    }

    public Notification getNotification() {
        return this.notification;
    }

    public void setNotification(Notification notification) {
        this.notification = notification;
    }

    public static interface Notification {
        public void notify(Transaction var1, TransactionEntry var2) throws SystemException, RollbackException;
    }
}

