/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.transaction.TransactionSetup;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"})
public class ReplicatedTransactionDeadlockTest {
    private static final int NUM_WORKERS = 2;
    private static final int NUM_RUNS = 100;
    private static final long LOCK_ACQUISITION_TIMEOUT = 10000L;
    private static volatile Exception exception = null;
    private CacheSPI<Boolean, Boolean> srcCache = null;
    private CacheSPI dstCache = null;
    private Log log = LogFactory.getLog(ReplicatedTransactionDeadlockTest.class);

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        exception = null;
        DefaultCacheFactory instance = new DefaultCacheFactory();
        this.srcCache = (CacheSPI)instance.createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC), false);
        this.srcCache.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.srcCache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.srcCache.getConfiguration().setSyncCommitPhase(true);
        this.srcCache.getConfiguration().setLockAcquisitionTimeout(10000L);
        this.srcCache.create();
        this.srcCache.start();
        this.dstCache = (CacheSPI)instance.createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC), false);
        this.dstCache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.dstCache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        this.dstCache.getConfiguration().setSyncCommitPhase(true);
        this.dstCache.getConfiguration().setLockAcquisitionTimeout(10000L);
        this.dstCache.create();
        this.dstCache.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.srcCache.stop();
        this.srcCache = null;
        this.dstCache.stop();
        this.dstCache = null;
        TransactionSetup.cleanup();
    }

    public void testConcurrentReplicatedTransaction() throws Exception {
        this.performTest();
    }

    private void performTest() throws Exception {
        for (int i = 0; i < 100; ++i) {
            if (exception != null) {
                AssertJUnit.fail((String)("Due to an exception: " + exception));
            }
            Worker[] t = new Worker[2];
            for (int j = 0; j < t.length; ++j) {
                t[j] = new Worker("worker " + i + ":" + j);
                t[j].start();
            }
            for (Worker aT : t) {
                aT.join();
            }
        }
    }

    private UserTransaction getTransaction() {
        return TransactionSetup.getUserTransaction();
    }

    private class Worker
    extends Thread {
        public Worker(String name) {
            super(name);
        }

        public void run() {
            try {
                UserTransaction tx = ReplicatedTransactionDeadlockTest.this.getTransaction();
                ReplicatedTransactionDeadlockTest.this.log.warn((Object)"begin");
                tx.begin();
                ReplicatedTransactionDeadlockTest.this.log.warn((Object)"put");
                ReplicatedTransactionDeadlockTest.this.srcCache.put("/Node", (Object)Boolean.FALSE, (Object)Boolean.TRUE);
                ReplicatedTransactionDeadlockTest.this.log.warn((Object)"commit");
                tx.commit();
                ReplicatedTransactionDeadlockTest.this.log.warn((Object)"leave");
            }
            catch (Exception e) {
                ReplicatedTransactionDeadlockTest.this.log.error((Object)("caught exception " + e), (Throwable)e);
                exception = e;
            }
        }
    }
}

