package org.jboss.cache.pojo.demo;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.PojoCacheFactory;

/**
 * PojoCac
 *
 * @author <a href="mailto:galder.zamarreno@jboss.com">Galder Zamarreno</a>
 */
public class PojoCacheView extends JBossCacheView
{
   private static Log log = LogFactory.getLog(PojoCacheView.class.getName());

   @Override
   protected CacheModelDelegate createCacheDelegate() throws Exception
   {
      PojoCache pojoCache = PojoCacheFactory.createCache(getConfigurationFile(), false);
      CacheModelDelegate delegate = new PojoCacheModelDelegate();
      delegate.setCacheShellVariable(pojoCache);

      return delegate;
   }

   @Override
   protected JBossCacheGUI createGUI(CacheModelDelegate delegate, boolean useConsole) throws Exception
   {
      return new PojoCacheGUI(delegate, useConsole);
   }

   public static void main(String args[])
   {
      try
      {
         JBossCacheView view = new PojoCacheView();
         view.doMain(args);
      }
      catch (Exception ex)
      {
         log.error("Cannot start up!!", ex);
         System.exit(-1);
      }
   }
}
