/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.pojo.test;


/**
 * Test class for PojoCache for circular references.
 * Link is a POJO that will be instrumentet with CacheFieldInterceptor
 *
 * @version $Revision: 6991 $
 *          <p>Below is the annotation that signifies this class is "prepared" under JBossAop. This is used in
 *          conjunction with a special jboss-aop.xml (supplied by JBossCache). In addition, this is JDK1.4 style,
 *          so a annoc Ant build target is needed to pre-compile it.</p>
 *          <p>To use this approach, just apply this line to your pojo and run annoc (and possibly aopc).</p>
 */
// We are using JDK1.5 annotation.
@org.jboss.cache.pojo.annotation.Replicable
public class Link
{
   Link link_;
   String name_;

   public Link()
   {
   }

   public Link(String name)
   {
      name_ = name;
   }

   public void setName(String linkName)
   {
      name_ = linkName;
   }

   public String getName()
   {
      return name_;
   }

   public void setLink(Link link)
   {
      link_ = link;
   }

   public Link getLink()
   {
      return link_;
   }

   public String toString()
   {
      StringBuffer buf = new StringBuffer();
      buf.append("Link: name " + name_);
      return buf.toString();
   }
}
