/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invalidation;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.FIFOConfiguration;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class TombstoneEvictionTest {
    private CacheSPI c1;
    private CacheSPI c2;
    private Fqn fqn = Fqn.fromString((String)"/data/test");
    private Fqn dummy = Fqn.fromString((String)"/data/dummy");
    private long evictionWaitTime = 4100L;
    private static final Log log = LogFactory.getLog(TombstoneEvictionTest.class);

    @BeforeMethod
    public void setUp() throws Exception {
        log.trace((Object)"**** setup called");
        this.c1 = (CacheSPI)new DefaultCacheFactory().createCache(false);
        FIFOConfiguration cfg = new FIFOConfiguration();
        cfg.setMaxNodes(1);
        cfg.setMinTimeToLiveSeconds(0);
        EvictionRegionConfig regionCfg = new EvictionRegionConfig();
        regionCfg.setRegionFqn(this.dummy.getParent());
        regionCfg.setRegionName(this.dummy.getParent().toString());
        regionCfg.setEvictionPolicyConfig((EvictionPolicyConfig)cfg);
        ArrayList<EvictionRegionConfig> evictionRegionConfigs = new ArrayList<EvictionRegionConfig>();
        evictionRegionConfigs.add(regionCfg);
        EvictionConfig ec = new EvictionConfig();
        ec.setWakeupIntervalSeconds(2);
        ec.setEvictionRegionConfigs(evictionRegionConfigs);
        this.c1.getConfiguration().setCacheMode(Configuration.CacheMode.INVALIDATION_SYNC);
        this.c1.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.c1.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.c1.getConfiguration().setEvictionConfig(ec);
        this.c2 = (CacheSPI)new DefaultCacheFactory().createCache(this.c1.getConfiguration().clone(), false);
        this.c1.start();
        this.c2.start();
        TestingUtil.blockUntilViewsReceived(60000L, new Cache[]{this.c1, this.c2});
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.c1, this.c2});
    }

    public void testControl() {
        log.trace((Object)"***** entered testControl()");
        this.c1.put(this.fqn, (Object)"k", (Object)"v");
        this.c1.put(this.dummy, (Object)"k", (Object)"v");
        log.trace((Object)"***** nodes were added testControl()");
        assert (this.c1.peek(this.fqn, false, true) != null) : "Node should exist";
        assert (this.c1.peek(this.dummy, false, true) != null) : "Node should exist";
        log.trace((Object)"***** testControl() right before sleeping");
        TestingUtil.sleepThread(this.evictionWaitTime);
        log.trace((Object)"***** testControl() right after sleeping");
        assert (this.c1.peek(this.fqn, false, true) == null) : "Should have evicted";
        assert (this.c1.peek(this.dummy, false, true) != null) : "Node should exist";
    }

    public void testWithInvalidationMarkers() {
        log.trace((Object)" **** testWithInvalidationMarkers() before put");
        this.c1.put(this.fqn, (Object)"k", (Object)"v");
        this.c1.put(this.dummy, (Object)"k", (Object)"v");
        log.trace((Object)" **** testWithInvalidationMarkers() after put");
        assert (this.c1.peek(this.fqn, false, true) != null) : "Node should exist";
        assert (this.c1.peek(this.dummy, false, true) != null) : "Node should exist";
        assert (this.c2.peek(this.fqn, false, true) != null) : "Node should exist";
        assert (this.c2.peek(this.dummy, false, true) != null) : "Node should exist";
        TestingUtil.sleepThread(this.evictionWaitTime);
        assert (this.c1.peek(this.fqn, false, true) == null) : "Should have evicted";
        assert (this.c1.peek(this.dummy, false, true) != null) : "Node should exist";
        assert (this.c2.peek(this.fqn, false, true) == null) : "Should have evicted";
        assert (this.c2.peek(this.dummy, false, true) != null) : "Node should exist";
    }

    public void testWithTombstones() {
        this.c1.put(this.fqn, (Object)"k", (Object)"v");
        this.c1.removeNode(this.fqn);
        this.c1.put(this.dummy, (Object)"k", (Object)"v");
        assert (this.c1.peek(this.fqn, false, true) != null) : "Node should exist";
        assert (this.c1.peek(this.dummy, false, true) != null) : "Node should exist";
        assert (this.c2.peek(this.fqn, false, true) != null) : "Node should exist";
        assert (this.c2.peek(this.dummy, false, true) != null) : "Node should exist";
        TestingUtil.sleepThread(this.evictionWaitTime);
        assert (this.c1.peek(this.fqn, false, true) == null) : "Should have evicted";
        assert (this.c1.peek(this.dummy, false, true) != null) : "Node should exist";
        assert (this.c2.peek(this.fqn, false, true) == null) : "Should have evicted";
        assert (this.c2.peek(this.dummy, false, true) != null) : "Node should exist";
    }
}

