/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import java.util.HashSet;
import org.jboss.cache.util.BitEncodedIntegerSet;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class BitEncodedIntegerSetTest {
    public void testLimits() {
        BitEncodedIntegerSet set = new BitEncodedIntegerSet();
        set.add(0);
        set.add(1);
        set.add(62);
        set.add(63);
        for (int i = 0; i < 64; ++i) {
            if (i == 0 || i == 1 || i == 62 || i == 63) {
                assert (set.contains(i)) : "Should contain " + i;
                continue;
            }
            assert (!set.contains(i)) : "Should not contain " + i;
        }
    }

    public void testRemoval() {
        BitEncodedIntegerSet set = new BitEncodedIntegerSet();
        set.add(0);
        set.add(1);
        set.add(62);
        set.add(63);
        set.remove(0);
        set.remove(63);
        for (int i = 0; i < 64; ++i) {
            if (i == 1 || i == 62 ? !$assertionsDisabled && !set.contains(i) : !$assertionsDisabled && set.contains(i)) {
                throw new AssertionError();
            }
        }
    }

    public void testAddAll() {
        int i;
        BitEncodedIntegerSet set = new BitEncodedIntegerSet();
        set.add(0);
        set.add(1);
        set.add(62);
        set.add(63);
        for (int i2 = 0; i2 < 64; ++i2) {
            if (i2 == 0 || i2 == 1 || i2 == 62 || i2 == 63 ? !$assertionsDisabled && !set.contains(i2) : !$assertionsDisabled && set.contains(i2)) {
                throw new AssertionError();
            }
        }
        BitEncodedIntegerSet set2 = new BitEncodedIntegerSet();
        set2.add(0);
        set2.add(1);
        set2.add(44);
        set2.add(55);
        for (i = 0; i < 64; ++i) {
            if (i == 0 || i == 1 || i == 44 || i == 55 ? !$assertionsDisabled && !set2.contains(i) : !$assertionsDisabled && set2.contains(i)) {
                throw new AssertionError();
            }
        }
        set.addAll(set2);
        for (i = 0; i < 64; ++i) {
            if (i == 0 || i == 1 || i == 62 || i == 63 || i == 44 || i == 55) {
                assert (set.contains(i)) : "Should contain " + i;
                continue;
            }
            assert (!set.contains(i));
        }
    }

    public void testClear() {
        BitEncodedIntegerSet set = new BitEncodedIntegerSet();
        set.add(0);
        set.add(1);
        set.add(62);
        set.add(63);
        for (int i = 0; i < 64; ++i) {
            if (i == 0 || i == 1 || i == 62 || i == 63 ? !$assertionsDisabled && !set.contains(i) : !$assertionsDisabled && set.contains(i)) {
                throw new AssertionError();
            }
        }
        set.clear();
        assert (set.isEmpty());
    }

    public void testIsEmpty() {
        BitEncodedIntegerSet set = new BitEncodedIntegerSet();
        assert (set.isEmpty());
        set.add(1);
        assert (!set.isEmpty());
    }

    public void testEquals() {
        BitEncodedIntegerSet set1 = new BitEncodedIntegerSet();
        BitEncodedIntegerSet set2 = new BitEncodedIntegerSet();
        assert (set1.equals((Object)set2));
        assert (set2.equals((Object)set1));
        set1.add(1);
        assert (!set1.equals((Object)set2));
        assert (!set2.equals((Object)set1));
        set2.add(1);
        assert (set1.equals((Object)set2));
        assert (set2.equals((Object)set1));
        set2.add(2);
        assert (!set1.equals((Object)set2));
        assert (!set2.equals((Object)set1));
        assert (set1.equals((Object)set1));
        assert (!set1.equals(null));
        assert (!set1.equals(new HashSet()));
    }

    public void testHashCode() {
        BitEncodedIntegerSet set = new BitEncodedIntegerSet();
        int hash = set.hashCode();
        assert (hash >= Integer.MIN_VALUE);
        assert (hash <= Integer.MAX_VALUE);
    }

    public void testToString() {
        BitEncodedIntegerSet set = new BitEncodedIntegerSet();
        assert (set.toString() != null);
    }
}

