/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.cache.util.DeltaMap;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"})
public class DeltaMapTest {
    static String Y = "y";
    static String Z = "z";
    static String K = "k";
    HashMap<String, String> hm;
    HashMap<String, String> backup;
    DeltaMap<String, String> dm;

    @BeforeMethod
    public void setUp() {
        this.hm = new HashMap();
        this.hm.put(null, null);
        this.hm.put(Y, Z);
        this.hm.put(K, Y);
        this.backup = new HashMap<String, String>(this.hm);
        this.dm = DeltaMap.create(this.hm);
        AssertJUnit.assertEquals((boolean)false, (boolean)this.dm.isModified());
        AssertJUnit.assertEquals(this.hm, this.dm);
    }

    public void testSize() {
        AssertJUnit.assertEquals((int)3, (int)this.dm.size());
        this.dm.put((Object)Y, (Object)"HI");
        AssertJUnit.assertEquals((int)3, (int)this.dm.size());
        this.dm.remove((Object)Y);
        AssertJUnit.assertEquals((int)2, (int)this.dm.size());
        this.hm.clear();
        AssertJUnit.assertEquals((int)0, (int)this.dm.size());
        this.dm.put((Object)Z, (Object)Z);
        this.dm.getRemoved().add("NOT HERE");
        AssertJUnit.assertEquals((int)1, (int)this.dm.size());
    }

    public void testConcurrent() throws Exception {
        ConcurrentHashMap<Object, String> m = new ConcurrentHashMap<Object, String>();
        m.put(new Object(), Z);
        m.put(new Object(), Y);
        DeltaMap dm = DeltaMap.create(m);
        AssertJUnit.assertEquals(m, (Object)dm);
        AssertJUnit.assertEquals((String)m.toString(), (String)dm.toString());
    }

    public void testChanges() throws Exception {
        AssertJUnit.assertEquals((String)("" + this.dm.toDebugString()), this.backup, this.dm);
        AssertJUnit.assertEquals((String)Z, (String)((String)this.dm.remove((Object)Y)));
        AssertJUnit.assertEquals((boolean)true, (boolean)this.dm.isModified());
        AssertJUnit.assertEquals(null, (String)((String)this.dm.remove((Object)Y)));
        AssertJUnit.assertEquals((String)"changes not made to underlying map", this.backup, this.hm);
        AssertJUnit.assertEquals((boolean)false, (boolean)this.dm.containsKey((Object)Y));
        AssertJUnit.assertEquals((boolean)false, (boolean)this.dm.containsValue((Object)Z));
        AssertJUnit.assertEquals(null, (String)((String)this.dm.put((Object)Y, (Object)Z)));
        AssertJUnit.assertEquals((String)Z, (String)((String)this.dm.put((Object)Y, (Object)Z)));
        AssertJUnit.assertEquals((String)"changes not made to underlying map", this.backup, this.hm);
        AssertJUnit.assertEquals((int)this.backup.size(), (int)this.dm.size());
        AssertJUnit.assertEquals(this.backup, this.dm);
        this.dm.commit();
        AssertJUnit.assertEquals(this.hm, this.dm);
        this.dm.commit();
        AssertJUnit.assertEquals(this.hm, this.dm);
    }

    public void testAddRemove() throws Exception {
        this.dm.remove((Object)K);
        this.dm.put((Object)K, (Object)Z);
        AssertJUnit.assertEquals((String)Z, (String)((String)this.dm.get((Object)K)));
        AssertJUnit.assertEquals((String)Z, (String)((String)this.dm.remove((Object)K)));
        AssertJUnit.assertEquals(null, (String)((String)this.dm.remove((Object)K)));
    }

    public void testExclude() throws Exception {
        this.dm = DeltaMap.excludeKeys(this.hm, (Object[])new String[]{Y});
        AssertJUnit.assertEquals((boolean)false, (boolean)this.dm.containsKey((Object)Y));
    }

    public void testExclude2() throws Exception {
        this.dm = DeltaMap.excludeKeys(this.hm, this.hm.keySet());
        AssertJUnit.assertEquals((boolean)true, (boolean)this.dm.isModified());
        AssertJUnit.assertEquals((int)0, (int)this.dm.size());
    }

    public void testClearedMap() throws Exception {
        this.dm.clear();
        AssertJUnit.assertEquals((int)0, (int)this.dm.size());
        AssertJUnit.assertEquals(this.backup, this.hm);
        AssertJUnit.assertEquals(null, (String)((String)this.dm.remove((Object)Y)));
    }

    public void testIterator() throws Exception {
        this.dm.remove(null);
        this.dm.put((Object)K, (Object)Y);
        System.out.println(this.dm.toDebugString());
        System.out.println(this.dm.toString());
        Iterator i = this.dm.entrySet().iterator();
        AssertJUnit.assertEquals((boolean)true, (boolean)i.hasNext());
        AssertJUnit.assertEquals((boolean)true, (boolean)i.hasNext());
        i.next();
        AssertJUnit.assertEquals((boolean)true, (boolean)i.hasNext());
        i.next();
        AssertJUnit.assertEquals((String)("" + this.dm), (boolean)false, (boolean)i.hasNext());
        try {
            i.next();
            AssertJUnit.fail((String)"no next");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        try {
            i.next();
            AssertJUnit.fail((String)"no next");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testEx() {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("a", "apple");
        DeltaMap dm = DeltaMap.create(hm);
        dm.remove((Object)"a");
        assert (hm.containsKey("a"));
        assert (!dm.containsKey((Object)"a"));
        dm.commit();
        assert (!hm.containsKey("a"));
    }
}

