/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Version;
import org.jboss.cache.statetransfer.DefaultStateTransferGenerator;
import org.jboss.cache.statetransfer.DefaultStateTransferIntegrator;
import org.jboss.cache.statetransfer.StateTransferGenerator;
import org.jboss.cache.statetransfer.StateTransferIntegrator;

public abstract class StateTransferFactory {
    private static final short RV_200 = Version.getVersionShort("2.0.0");
    private static final Log log = LogFactory.getLog(StateTransferFactory.class);

    public static StateTransferGenerator getStateTransferGenerator(CacheSPI cache) {
        short version = cache.getConfiguration().getReplicationVersion();
        if (version < RV_200 && version > 0) {
            throw new IllegalStateException("State transfer with cache replication version < 2.0.0 not supported");
        }
        return new DefaultStateTransferGenerator(cache);
    }

    public static StateTransferIntegrator getStateTransferIntegrator(ObjectInputStream in, Fqn fqn, CacheSPI cache) throws Exception {
        short version;
        try {
            version = (Short)cache.getMarshaller().objectFromObjectStream(in);
        }
        catch (IOException io) {
            block5: {
                try {
                    in.close();
                }
                catch (IOException e) {
                    if (!log.isWarnEnabled()) break block5;
                    log.warn((Object)"Unable to close stream!", (Throwable)e);
                }
            }
            throw new IllegalStateException("Stream corrupted ", io);
        }
        if (version < RV_200 && version > 0) {
            throw new IllegalStateException("State transfer with cache replication version < 2.0.0 not supported");
        }
        return new DefaultStateTransferIntegrator(fqn, cache);
    }
}

