/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.pojo.region;

import static org.testng.AssertJUnit.assertEquals;
import static org.testng.AssertJUnit.assertNull;
import static org.testng.AssertJUnit.fail;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.PojoCacheFactory;
import org.jboss.cache.pojo.impl.InternalConstant;
import org.jboss.cache.pojo.test.Person;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Additional basic tests
 *
 * @author Ben Wang
 */

@Test(groups = {"functional"})
public class NewLocalTest
{
   Log log_ = LogFactory.getLog(org.jboss.cache.pojo.region.NewLocalTest.class);
   PojoCache cache_;


   @BeforeMethod(alwaysRun = true)
   protected void setUp() throws Exception
   {
      log_.info("setUp() ....");
      String configFile = "META-INF/local-service.xml";
      boolean toStart = false;
      cache_ = PojoCacheFactory.createCache(configFile, toStart);
      cache_.start();
      cache_.getCache().getRegion(Fqn.fromString("SESSION"), true);
   }

   @AfterMethod(alwaysRun = true)
   protected void tearDown() throws Exception
   {
      cache_.stop();
   }

//   public void testDummy() {}

   /**
    * Not applied anymore.
    *
    * @throws Exception
    */
   @Test(enabled = false)
   public void XtestBadFqn() throws Exception
   {
      log_.info("testBadFqn() ....");
      Person test = new Person();
      test.setName("Ben");
      test.setAge(10);
      cache_.attach("/a", test);
      Person result = (Person) cache_.detach("/a");
      assertEquals(" ", test, result);
      result.setAge(20);

      try
      {
         cache_.attach(InternalConstant.JBOSS_INTERNAL_STRING, test);
         fail("putObject under JBoss_Internal should fail");
      }
      catch (IllegalArgumentException iex)
      {
         // ok
      }

      try
      {
         cache_.detach(InternalConstant.JBOSS_INTERNAL_STRING);
         fail("putObject under JBoss_Internal should fail");
      }
      catch (IllegalArgumentException iex)
      {
         // ok
      }
   }

   public void testPutRemove() throws Exception
   {
      log_.info("testPutRemove() ....");
      Person test = new Person();
      test.setName("Ben");
      test.setAge(10);
      cache_.attach("/a", test);
      Person result = (Person) cache_.find("/a");
      assertEquals(" ", test, result);
      result.setAge(20);
      cache_.detach("/a");
      assertNull("Object should be null ", cache_.find("/a"));
      assertEquals("Age should be updated as ", 20, test.getAge());
   }

   public void testPutRemoveNodeExistence() throws Exception
   {
      log_.info("testPutRemove() ....");
      Person test = new Person();
      test.setName("Ben");
      test.setAge(10);
      cache_.attach("person", test);
      Person result = (Person) cache_.find("person");
      assertEquals(" ", test, result);
      result.setAge(20);
      cache_.detach("person");
      assertNull("Object should be null ", cache_.find("person"));
      assertEquals("Age should be updated as ", 20, test.getAge());

      assertNull("DataNode should not exisit ", cache_.getCache().getRoot().get("person"));
   }

   public void testFindObjects() throws Exception
   {
      log_.info("testFindObjects() ....");
      Map<?, ?> map = cache_.findAll("/");
      assertEquals("Objects size should be ", 0, map.size());
      Person ben = new Person();
      ben.setName("Ben");
      ben.setAge(10);
      cache_.attach("/a/b/c", ben);
      cache_.attach("/e", ben); // multiple keys, same pojo
      Person joe = new Person();
      joe.setName("Joe");
      joe.setAge(10);
      cache_.attach("/f/joe", joe);
      map = cache_.findAll("/");
      assertEquals("Objects size should be ", 3, map.size());

      map = cache_.findAll("/a");
      assertEquals("Objects size should be ", 1, map.size());
      cache_.detach("/e");
      map = cache_.findAll("/");
      assertEquals("Objects size should be ", 2, map.size());
   }
}