/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.notifications.annotation.BuddyGroupChanged;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.event.Event;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "jgroups"})
public class BuddyAssignmentStateTransferTest
extends BuddyReplicationTestsBase {
    protected int timeout = 10000;

    @Override
    protected int getSleepTimeout() {
        return this.timeout;
    }

    private void createCacheWithLatch(CountDownLatch latch) throws Exception {
        CacheSPI<Object, Object> cache2 = this.createCache(1, "TEST", false, false);
        cache2.create();
        cache2.addCacheListener((Object)new BuddyJoinedListener(latch));
        cache2.start();
        this.caches.add(cache2);
    }

    private void replaceLatch(Cache<?, ?> cache, CountDownLatch newLatch) {
        BuddyJoinedListener bjl = null;
        for (Object listener : cache.getCacheListeners()) {
            if (!(listener instanceof BuddyJoinedListener)) continue;
            bjl = (BuddyJoinedListener)listener;
            break;
        }
        if (bjl != null) {
            cache.removeCacheListener(bjl);
        }
        cache.addCacheListener((Object)new BuddyJoinedListener(newLatch));
    }

    public void testNonRegionBasedStateTransfer() throws Exception {
        this.caches = new ArrayList();
        this.caches.add(this.createCache(1, "TEST", false, true));
        Fqn main = Fqn.fromString((String)"/a/b/c");
        ((CacheSPI)this.caches.get(0)).put(main, (Object)"name", (Object)"Joe");
        CountDownLatch latch = new CountDownLatch(1);
        this.createCacheWithLatch(latch);
        assert (latch.await(this.getSleepTimeout(), TimeUnit.MILLISECONDS)) : "Buddy groups not formed after " + this.getSleepTimeout() + " millis!";
        Fqn test = this.fqnTransformer.getBackupFqn(((CacheSPI)this.caches.get(0)).getLocalAddress(), main);
        AssertJUnit.assertEquals((String)"State not transferred", (Object)"Joe", (Object)((CacheSPI)this.caches.get(1)).get(test, (Object)"name"));
        latch = new CountDownLatch(1);
        this.createCacheWithLatch(latch);
        assert (latch.await(this.getSleepTimeout(), TimeUnit.MILLISECONDS)) : "Buddy groups not formed after " + this.getSleepTimeout() + " millis!";
        AssertJUnit.assertNull((String)"State not transferred", (Object)((CacheSPI)this.caches.get(2)).get(test, (Object)"name"));
        latch = new CountDownLatch(1);
        this.replaceLatch((Cache)this.caches.get(2), latch);
        this.replaceLatch((Cache)this.caches.get(0), latch);
        ((CacheSPI)this.caches.get(1)).stop();
        this.caches.set(1, null);
        assert (latch.await(this.getSleepTimeout(), TimeUnit.MILLISECONDS)) : "Buddy groups not formed after " + this.getSleepTimeout() + " millis!";
        AssertJUnit.assertEquals((String)"State transferred", (Object)"Joe", (Object)((CacheSPI)this.caches.get(2)).get(test, (Object)"name"));
    }

    public void testRegionBasedStateTransfer() throws Exception {
        this.caches = new ArrayList();
        CountDownLatch latch = new CountDownLatch(4);
        this.caches.add(this.createCache(1, "TEST", false, false));
        this.caches.add(this.createCache(1, "TEST", false, false));
        this.caches.add(this.createCache(1, "TEST", false, false));
        this.caches.add(this.createCache(1, "TEST", false, false));
        for (CacheSPI c : this.caches) {
            c.getConfiguration().setInactiveOnStartup(true);
            c.getConfiguration().setUseRegionBasedMarshalling(true);
            c.create();
            c.addCacheListener((Object)new BuddyJoinedListener(latch));
        }
        for (CacheSPI c : this.caches) {
            c.start();
        }
        assert (latch.await(this.getSleepTimeout(), TimeUnit.MILLISECONDS)) : "Buddy groups not formed after " + this.getSleepTimeout() + " millis!";
        Fqn fqnA = Fqn.fromString((String)"/a");
        Fqn fqnD = Fqn.fromString((String)"/d");
        ClassLoader cl = Fqn.class.getClassLoader();
        for (CacheSPI c : this.caches) {
            c.getRegion(fqnA, true).registerContextClassLoader(cl);
            c.getRegion(fqnD, true).registerContextClassLoader(cl);
        }
        for (CacheSPI c : this.caches) {
            c.getRegion(fqnA, true).activate();
        }
        ((CacheSPI)this.caches.get(0)).getRegion(fqnD, true).activate();
        ((CacheSPI)this.caches.get(1)).getRegion(fqnD, true).activate();
        Fqn mainA = Fqn.fromString((String)"/a/b/c");
        ((CacheSPI)this.caches.get(0)).put(mainA, (Object)"name", (Object)"Joe");
        Fqn mainD = Fqn.fromString((String)"/d/e/f");
        ((CacheSPI)this.caches.get(0)).put(mainD, (Object)"name", (Object)"Joe");
        Fqn testA = this.fqnTransformer.getBackupFqn(((CacheSPI)this.caches.get(0)).getLocalAddress(), mainA);
        AssertJUnit.assertEquals((String)"/a replicated", (Object)"Joe", (Object)((CacheSPI)this.caches.get(1)).get(testA, (Object)"name"));
        AssertJUnit.assertNull((String)"No backup of /a", (Object)((CacheSPI)this.caches.get(2)).get(testA, (Object)"name"));
        Fqn testD = this.fqnTransformer.getBackupFqn(((CacheSPI)this.caches.get(0)).getLocalAddress(), mainD);
        AssertJUnit.assertEquals((String)"/d replicated", (Object)"Joe", (Object)((CacheSPI)this.caches.get(1)).get(testD, (Object)"name"));
        AssertJUnit.assertNull((String)"No backup of /d", (Object)((CacheSPI)this.caches.get(2)).get(testD, (Object)"name"));
        latch = new CountDownLatch(1);
        this.replaceLatch((Cache)this.caches.get(2), latch);
        this.replaceLatch((Cache)this.caches.get(0), latch);
        ((CacheSPI)this.caches.get(1)).stop();
        assert (latch.await(this.getSleepTimeout(), TimeUnit.MILLISECONDS)) : "Buddy groups not formed after " + this.getSleepTimeout() + " millis!";
        AssertJUnit.assertEquals((String)"/a state transferred", (Object)"Joe", (Object)((CacheSPI)this.caches.get(2)).get(testA, (Object)"name"));
        AssertJUnit.assertNull((String)"/d state not transferred", (Object)((CacheSPI)this.caches.get(2)).get(testD, (Object)"name"));
        ((CacheSPI)this.caches.get(2)).getRegion(fqnD, true).activate();
        ((CacheSPI)this.caches.get(3)).getRegion(fqnD, true).activate();
        AssertJUnit.assertEquals((String)"/d transferred to cache 2", (Object)"Joe", (Object)((CacheSPI)this.caches.get(2)).get(testD, (Object)"name"));
        AssertJUnit.assertNull((String)"/d state not transferred to cache 3", (Object)((CacheSPI)this.caches.get(3)).get(testD, (Object)"name"));
    }

    public void testPersistentStateTransfer() throws Exception {
        this.caches = new ArrayList();
        CountDownLatch latch = new CountDownLatch(2);
        this.caches.add(this.createCacheWithCacheLoader(false, false, false, true, false));
        ((CacheSPI)this.caches.get(0)).getConfiguration().setFetchInMemoryState(false);
        ((CacheSPI)this.caches.get(0)).create();
        ((CacheSPI)this.caches.get(0)).addCacheListener((Object)new BuddyJoinedListener(latch));
        ((CacheSPI)this.caches.get(0)).start();
        Fqn main = Fqn.fromString((String)"/a/b/c");
        ((CacheSPI)this.caches.get(0)).put(main, (Object)"name", (Object)"Joe");
        this.caches.add(this.createCacheWithCacheLoader(false, false, false, true, false));
        ((CacheSPI)this.caches.get(1)).getConfiguration().setFetchInMemoryState(false);
        ((CacheSPI)this.caches.get(1)).create();
        ((CacheSPI)this.caches.get(1)).addCacheListener((Object)new BuddyJoinedListener(latch));
        ((CacheSPI)this.caches.get(1)).start();
        assert (latch.await(this.getSleepTimeout(), TimeUnit.MILLISECONDS)) : "Buddy groups not formed after " + this.getSleepTimeout() + " millis!";
        Fqn test = this.fqnTransformer.getBackupFqn(((CacheSPI)this.caches.get(0)).getLocalAddress(), main);
        AssertJUnit.assertFalse((String)"/a/b/c shld not be bin memory", (boolean)((CacheSPI)this.caches.get(1)).exists(test));
        AssertJUnit.assertNotNull((String)"/a/b/c shld be in CL", (Object)((CacheSPI)this.caches.get(1)).getCacheLoaderManager().getCacheLoader().get(test));
        AssertJUnit.assertEquals((String)"/a/b/c shld in cache loader", (Object)"Joe", (Object)((CacheSPI)this.caches.get(1)).get(test, (Object)"name"));
    }

    @CacheListener
    public static class BuddyJoinedListener {
        CountDownLatch latch;

        public BuddyJoinedListener(CountDownLatch latch) {
            this.latch = latch;
        }

        @BuddyGroupChanged
        public void buddyJoined(Event e) {
            this.latch.countDown();
        }
    }
}

