/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.cache.util.MinMapUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"})
public class MinMapUtilTest {
    private static final Map<String, String> empty = Collections.emptyMap();
    private Map<String, String> map;
    private String key = "a";
    private String key2 = "b";
    private String value = "y";

    @BeforeMethod
    public void before() {
        this.map = empty;
    }

    public void testRemove() {
        AssertJUnit.assertSame(this.map, (Object)MinMapUtil.remove(this.map, (Object)this.key));
        this.map = MinMapUtil.put(this.map, (Object)this.key, (Object)this.value);
        this.map = MinMapUtil.put(this.map, (Object)this.key2, (Object)this.value);
        AssertJUnit.assertEquals((String)this.value, (String)this.map.get(this.key));
        AssertJUnit.assertEquals((String)this.value, (String)this.map.get(this.key2));
        MinMapUtil.remove(this.map, (Object)this.key2);
        AssertJUnit.assertSame(this.map, (Object)MinMapUtil.remove(this.map, (Object)"not here"));
        AssertJUnit.assertSame(empty, (Object)MinMapUtil.remove(this.map, (Object)this.key));
    }

    public void testPut() {
        AssertJUnit.assertSame(this.map, (Object)MinMapUtil.remove(this.map, (Object)this.key));
        this.map = MinMapUtil.put(this.map, (Object)this.key, (Object)this.value);
        AssertJUnit.assertEquals((int)1, (int)this.map.size());
        AssertJUnit.assertEquals((boolean)true, (boolean)this.map.containsKey(this.key));
        this.map = MinMapUtil.put(this.map, (Object)this.key, (Object)this.value);
        AssertJUnit.assertEquals((int)1, (int)this.map.size());
        AssertJUnit.assertEquals((boolean)true, (boolean)this.map.containsKey(this.key));
        this.map = MinMapUtil.put(this.map, (Object)this.key2, (Object)this.value);
        AssertJUnit.assertEquals((int)2, (int)this.map.size());
    }

    public void testPutAll() {
        HashMap<String, String> hm = new HashMap<String, String>();
        AssertJUnit.assertSame(empty, (Object)MinMapUtil.putAll(this.map, hm));
        hm.put(this.key, this.value);
        AssertJUnit.assertEquals((int)1, (int)MinMapUtil.putAll(this.map, hm).size());
        hm.put(this.key2, this.value);
        AssertJUnit.assertEquals((int)2, (int)MinMapUtil.putAll(this.map, hm).size());
    }
}

