/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Region;
import org.jboss.cache.eviction.BaseSortedEvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.LFUConfiguration;
import org.jboss.cache.eviction.LFUQueue;
import org.jboss.cache.eviction.NodeEntry;

public class LFUAlgorithm
extends BaseSortedEvictionAlgorithm {
    private static final Log log = LogFactory.getLog(LFUAlgorithm.class);
    private static final boolean trace = log.isTraceEnabled();

    protected boolean shouldEvictNode(NodeEntry ne) {
        if (trace) {
            log.trace((Object)("Deciding whether node in queue " + ne.getFqn() + " requires eviction."));
        }
        if (this.isYoungerThanMinimumTimeToLive(ne)) {
            return false;
        }
        LFUConfiguration config = (LFUConfiguration)this.region.getEvictionPolicyConfig();
        int size = this.getEvictionQueue().getNumberOfNodes();
        if (config.getMaxNodes() != 0 && size > config.getMaxNodes()) {
            return true;
        }
        return size > config.getMinNodes();
    }

    protected EvictionQueue setupEvictionQueue(Region region) throws EvictionException {
        return new LFUQueue();
    }

    protected void prune() throws EvictionException {
        super.prune();
        ((LFUQueue)this.evictionQueue).prune();
    }
}

