/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.demo;

import bsh.ConsoleInterface;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.util.JConsole;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.demo.CacheModelDelegate;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeCreated;
import org.jboss.cache.notifications.annotation.NodeEvicted;
import org.jboss.cache.notifications.annotation.NodeLoaded;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.NodeEvent;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.jboss.cache.util.CachePrinter;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CacheListener
public class JBossCacheGUI
extends JFrame
implements WindowListener,
TreeSelectionListener,
TableModelListener {
    private static final long serialVersionUID = -1242167331988194987L;
    private transient CacheModelDelegate cacheModelDelegate;
    private transient Cache cache;
    private DefaultTreeModel tree_model = null;
    private transient Log log = LogFactory.getLog(this.getClass());
    private JTree jtree = null;
    private DefaultTableModel tableModel = new DefaultTableModel();
    private JTable table = new JTable(this.tableModel);
    private DisplayNode myNodeRoot = new DisplayNode("/");
    private transient Node root;
    private transient Node selected_node = null;
    private JPanel tablePanel = null;
    private JPopupMenu operationsPopup = null;
    private JPopupMenu dataModificationsPopup = null;
    private static final int KEY_COL_WIDTH = 20;
    private static final int VAL_COL_WIDTH = 300;
    private TransactionManager tx_mgr = null;
    private transient Transaction tx = null;
    private JPanel mainPanel;
    private List<Address> membership = new LinkedList<Address>();
    private Address coordinator = null;
    private boolean useConsole = false;
    JConsole bshConsole;
    private transient Executor executor = Executors.newCachedThreadPool();

    public JBossCacheGUI(CacheModelDelegate cacheDelegate, boolean useConsole) throws Exception {
        this.addNotify();
        this.useConsole = useConsole;
        this.tree_model = new DefaultTreeModel(new DisplayNode(Fqn.ROOT.toString()));
        this.jtree = new JTree(this.tree_model);
        this.jtree.setDoubleBuffered(true);
        this.jtree.getSelectionModel().setSelectionMode(1);
        JScrollPane scroll_pane = new JScrollPane(this.jtree);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)scroll_pane, "Center");
        this.addWindowListener(this);
        this.tableModel.setColumnIdentifiers(new String[]{"Name", "Value"});
        this.tableModel.addTableModelListener(this);
        MouseAdapter dataMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (JBossCacheGUI.this.rightClick(e.getModifiers())) {
                    JBossCacheGUI.this.dataModificationsPopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.setTableColumnWidths();
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.add((Component)this.table.getTableHeader(), "North");
        this.tablePanel.add((Component)this.table, "Center");
        this.table.addMouseListener(dataMouseListener);
        this.mainPanel.add((Component)this.tablePanel, "South");
        JSplitPane contentPanel = null;
        if (useConsole) {
            String welcomeMessage = this.getWelcomeMessage();
            this.bshConsole = new JConsole();
            Interpreter interpreter = new Interpreter((ConsoleInterface)this.bshConsole);
            this.configureInterpreter(interpreter, cacheDelegate);
            interpreter.println((Object)welcomeMessage);
            interpreter.setShowResults(!interpreter.getShowResults());
            System.setOut(this.bshConsole.getOut());
            System.setErr(this.bshConsole.getErr());
            Thread t = new Thread((Runnable)interpreter);
            t.start();
            contentPanel = new JSplitPane(0, this.mainPanel, (Component)this.bshConsole);
            this.getContentPane().add(contentPanel);
        } else {
            this.getContentPane().add(this.mainPanel);
        }
        this.jtree.addTreeSelectionListener(this);
        MouseAdapter ml = new MouseAdapter(){

            public void mouseClicked(final MouseEvent e) {
                if (JBossCacheGUI.this.log.isTraceEnabled()) {
                    JBossCacheGUI.this.log.trace((Object)"clicked GUI");
                }
                int selRow = JBossCacheGUI.this.jtree.getRowForLocation(e.getX(), e.getY());
                final TreePath selPath = JBossCacheGUI.this.jtree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    if (JBossCacheGUI.this.log.isTraceEnabled()) {
                        JBossCacheGUI.this.log.trace((Object)"clicked on node in GUI");
                    }
                    Runnable r = new Runnable(){

                        public void run() {
                            try {
                                JBossCacheGUI.this.selected_node = JBossCacheGUI.this.getNode(selPath.getPath());
                                JBossCacheGUI.this.jtree.setSelectionPath(selPath);
                                if (JBossCacheGUI.this.rightClick(e.getModifiers())) {
                                    JBossCacheGUI.this.operationsPopup.show(e.getComponent(), e.getX(), e.getY());
                                }
                            }
                            catch (TimeoutException te) {
                                String message = "Unable to update GUI due to a timeout trying to acquire lock on a node.This might be due to clicking on a node which is currently locked by an ongoing transaction: ";
                                JBossCacheGUI.this.printAndLogStacktrace(message, te);
                            }
                            catch (Exception e2) {
                                JBossCacheGUI.this.printAndLogStacktrace("Updating GUI failed: ", e2);
                            }
                        }
                    };
                    JBossCacheGUI.this.executor.execute(r);
                }
            }
        };
        this.jtree.addMouseListener(ml);
        this.createMenus();
        this.setLocation(50, 50);
        this.setSize(this.getInsets().left + this.getInsets().right + 800, this.getInsets().top + this.getInsets().bottom + 800);
        this.setCacheModelDelegate(cacheDelegate);
        this.init();
        this.setVisible(true);
        this.tree_model.setRoot(this.myNodeRoot);
        this.tree_model.reload();
        if (useConsole) {
            contentPanel.setDividerLocation(0.65);
        }
    }

    public void setCacheModelDelegate(CacheModelDelegate cacheModelDelegate) {
        this.cacheModelDelegate = cacheModelDelegate;
        if (this.cacheModelDelegate != null) {
            this.cache = this.cacheModelDelegate.getGenericCache();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    JBossCacheGUI.this.cache.stop();
                }
            });
            this.cache.addCacheListener((Object)this);
            this.root = this.cache.getRoot();
            this.setTitle("JBoss Cache GUI: Local Address=" + this.getLocalAddress());
            this.tx_mgr = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
            this.populateTree();
        } else {
            this.setTitle("Cache undefined");
            if (this.tree_model != null) {
                this.myNodeRoot = new DisplayNode("/");
                this.tree_model.setRoot(this.myNodeRoot);
                this.tree_model.reload();
            }
            if (this.tableModel != null) {
                this.clearTable();
            }
        }
    }

    private boolean rightClick(int modifiers) {
        if (modifiers == 4) {
            return true;
        }
        return modifiers == 18;
    }

    @Override
    public void windowClosed(WindowEvent event) {
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    @Override
    public void windowOpened(WindowEvent event) {
    }

    @Override
    public void windowClosing(WindowEvent event) {
        this.stopGui();
    }

    @Override
    public void tableChanged(TableModelEvent evt) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("table contents changed, event type is: " + evt.getType()));
        }
        if (evt.getType() == 0) {
            int row = evt.getFirstRow();
            int col = evt.getColumn();
            String key = (String)this.tableModel.getValueAt(row, col == 0 ? 0 : col - 1);
            String val = (String)this.tableModel.getValueAt(row, col == 0 ? 1 : col);
            if (key != null && val != null && !this.isPlaceHolder(key) && !this.isPlaceHolder(val)) {
                try {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("updating node: " + this.selected_node + " with new values [k=" + key + ",v=" + val + "]"));
                    }
                    this.selected_node.put((Object)key, (Object)val);
                    Map data = this.selected_node.getData();
                    this.populateTable(data);
                }
                catch (Exception e) {
                    this.printAndLogStacktrace("Changing table failed: ", e);
                }
            }
        }
    }

    @Override
    public void valueChanged(final TreeSelectionEvent evt) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("node was selected in GUI: " + evt.getPath()));
        }
        Runnable r = new Runnable(){

            public void run() {
                try {
                    JBossCacheGUI.this.selected_node = JBossCacheGUI.this.getNode(evt.getPath().getPath());
                    if (JBossCacheGUI.this.selected_node != null) {
                        Map data = JBossCacheGUI.this.selected_node.getData();
                        if (data != null) {
                            JBossCacheGUI.this.mainPanel.add((Component)JBossCacheGUI.this.tablePanel, "South");
                            JBossCacheGUI.this.populateTable(data);
                            JBossCacheGUI.this.validate();
                        } else {
                            JBossCacheGUI.this.clearTable();
                            JBossCacheGUI.this.mainPanel.remove(JBossCacheGUI.this.tablePanel);
                            JBossCacheGUI.this.validate();
                        }
                    }
                }
                catch (TimeoutException te) {
                    String message = "Unable to update GUI due to a timeout trying to acquire lock on a node.This might be due to clicking on a node which is currently locked by an ongoing transaction: ";
                    JBossCacheGUI.this.printAndLogStacktrace(message, te);
                }
                catch (Exception e) {
                    JBossCacheGUI.this.printAndLogStacktrace("Updating GUI failed: ", e);
                }
            }
        };
        this.executor.execute(r);
    }

    protected DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    protected String getWelcomeMessage() {
        return "Welcome to the BeanShell console.\n\nThis console gives you a direct shell interface to the GUI above and allows you to manipulate the cache directly. Some of the variables initialised in this shell session are:\n\n// an instance of org.jboss.cache\n    Cache<String, String> cache;\n// a reference to the root node\n    Node<String, String> root;\n// the transaction manager registered with the cache\n    TransactionManager transactionManager;\n";
    }

    protected void configureInterpreter(Interpreter interpreter, CacheModelDelegate cacheDelegate) throws EvalError {
        interpreter.getNameSpace().importPackage("org.jboss.cache");
        interpreter.getNameSpace().importPackage("org.jboss.cache.transaction");
        interpreter.set("cache", (Object)cacheDelegate.getGenericCache());
        interpreter.set("root", (Object)cacheDelegate.getGenericCache().getRoot());
        interpreter.set("transactionManager", (Object)cacheDelegate.getGenericCache().getConfiguration().getRuntimeConfig().getTransactionManager());
    }

    @NodeCreated
    @NodeLoaded
    public void nodeCreated(NodeEvent e) {
        DisplayNode n;
        if (e.isPre() && (n = this.myNodeRoot.add((Fqn<String>)e.getFqn())) != null) {
            this.tree_model.setRoot(this.myNodeRoot);
            this.tree_model.reload();
            this.jtree.scrollPathToVisible(new TreePath(n.getPath()));
        }
    }

    @NodeModified
    public void nodeModified(final NodeModifiedEvent e) {
        Runnable r = new Runnable(){

            public void run() {
                if (e.isPre() && JBossCacheGUI.this.selected_node != null && JBossCacheGUI.this.selected_node.getFqn().equals((Object)e.getFqn())) {
                    JBossCacheGUI.this.clearTable();
                    Node n = JBossCacheGUI.this.root.getChild(e.getFqn());
                    if (n != null) {
                        JBossCacheGUI.this.populateTable(n.getData());
                    }
                }
            }
        };
        this.executor.execute(r);
    }

    @NodeRemoved
    @NodeEvicted
    public void nodeRemoved(final NodeEvent e) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"node removed, updating GUI");
        }
        Runnable r = new Runnable(){

            public void run() {
                DisplayNode n;
                if (e.isPre() && (n = JBossCacheGUI.this.myNodeRoot.findNode((Fqn<String>)e.getFqn())) != null) {
                    n.removeAllChildren();
                    n.removeFromParent();
                    JBossCacheGUI.this.tree_model.setRoot(JBossCacheGUI.this.myNodeRoot);
                    JBossCacheGUI.this.tree_model.reload();
                }
            }
        };
        this.executor.execute(r);
    }

    @ViewChanged
    public void viewChange(final ViewChangedEvent e) {
        Runnable r = new Runnable(){

            public void run() {
                Vector mbrship;
                if (e.getNewView() != null && (mbrship = e.getNewView().getMembers()) != null) {
                    JBossCacheGUI.this.membership.clear();
                    JBossCacheGUI.this.membership.addAll(mbrship);
                    JBossCacheGUI.this.coordinator = (Address)mbrship.get(0);
                }
            }
        };
        this.executor.execute(r);
    }

    public void run() {
    }

    private void init() {
        List<Address> mbrship = this.getMembers();
        if (mbrship != null && mbrship.size() > 0) {
            this.membership.clear();
            this.membership.addAll(mbrship);
            this.coordinator = mbrship.get(0);
        }
    }

    private void populateTree() {
        this.addGuiNode(Fqn.ROOT);
    }

    private void addGuiNode(Fqn fqn) {
        if (fqn == null) {
            return;
        }
        this.myNodeRoot.add((Fqn<String>)fqn);
        Set children = this.cache.getRoot().getChild(fqn).getChildrenNames();
        if (children != null) {
            for (Object child_name : children) {
                this.addGuiNode(Fqn.fromRelativeElements((Fqn)fqn, (Object[])new Object[]{(String)child_name}));
            }
        }
    }

    private Node getNode(Object[] path) {
        List<String> elements;
        Fqn fqnToPath;
        if (path.length == 0) {
            Fqn fqn = Fqn.ROOT;
        }
        if (this.root.hasChild(fqnToPath = Fqn.fromList(elements = this.convertMyNodeArrayToStringArray(path)))) {
            return this.root.getChild(fqnToPath);
        }
        return null;
    }

    private List<String> convertMyNodeArrayToStringArray(Object[] path) {
        LinkedList<String> list = new LinkedList<String>();
        for (Object o : path) {
            DisplayNode n = (DisplayNode)o;
            if (n.name.equals("/")) continue;
            list.add(n.name);
        }
        return list;
    }

    protected void clearTable() {
        int num_rows = this.table.getRowCount();
        if (num_rows > 0) {
            for (int i = 0; i < num_rows; ++i) {
                this.tableModel.removeRow(0);
            }
            this.tableModel.fireTableRowsDeleted(0, num_rows - 1);
            this.repaint();
        }
    }

    protected void populateTable(Map<String, String> data) {
        this.clearTable();
        if (data == null) {
            return;
        }
        int num_rows = data.size();
        if (num_rows > 0) {
            TreeMap<String, String> sortedMap = new TreeMap<String, String>(data);
            for (Map.Entry<String, String> entry : sortedMap.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                this.tableModel.addRow(new Object[]{key, val});
            }
            this.tableModel.fireTableRowsInserted(0, num_rows - 1);
            this.validate();
        }
    }

    private void setTableColumnWidths() {
        this.table.sizeColumnsToFit(1);
        TableColumn column = this.table.getColumnModel().getColumn(0);
        column.setMinWidth(20);
        column.setPreferredWidth(20);
        column = this.table.getColumnModel().getColumn(1);
        column.setPreferredWidth(300);
    }

    private void createMenus() {
        JMenuBar menubar = new JMenuBar();
        JMenu operationsMenu = new JMenu("Operations");
        AddNodeAction addNode = new AddNodeAction();
        addNode.putValue("Name", "Add to this node");
        LoadAction load_action = new LoadAction();
        load_action.putValue("Name", "Load from the CacheLoader");
        RemoveNodeAction removeNode = new RemoveNodeAction();
        removeNode.putValue("Name", "Remove this node");
        EvictAction evict_action = new EvictAction();
        evict_action.putValue("Name", "Evict from the Cache");
        AddModifyDataForNodeAction addModAction = new AddModifyDataForNodeAction();
        addModAction.putValue("Name", "Add/Modify data");
        PrintLockInfoAction print_locks = new PrintLockInfoAction();
        print_locks.putValue("Name", "Print lock information" + (this.useConsole ? "" : " (stdout)"));
        ExitAction exitAction = new ExitAction();
        exitAction.putValue("Name", "Exit");
        StartTransaction start_tx = new StartTransaction();
        start_tx.putValue("Name", "Start TX");
        CommitTransaction commit_tx = new CommitTransaction();
        commit_tx.putValue("Name", "Commit TX");
        RollbackTransaction rollback_tx = new RollbackTransaction();
        rollback_tx.putValue("Name", "Rollback TX");
        operationsMenu.add(addNode);
        operationsMenu.add(load_action);
        operationsMenu.add(removeNode);
        operationsMenu.add(evict_action);
        operationsMenu.add(addModAction);
        operationsMenu.add(print_locks);
        operationsMenu.add(start_tx);
        operationsMenu.add(commit_tx);
        operationsMenu.add(rollback_tx);
        operationsMenu.add(exitAction);
        menubar.add(operationsMenu);
        this.setJMenuBar(menubar);
        this.operationsPopup = new JPopupMenu();
        this.operationsPopup.add(addNode);
        this.operationsPopup.add(load_action);
        this.operationsPopup.add(evict_action);
        this.operationsPopup.add(removeNode);
        this.operationsPopup.add(addModAction);
        InsertRowAction insertRow = new InsertRowAction();
        insertRow.putValue("Name", "Insert New Row");
        RemoveLastRowAction removeLastRow = new RemoveLastRowAction();
        removeLastRow.putValue("Name", "Remove Last Row");
        this.dataModificationsPopup = new JPopupMenu();
        this.dataModificationsPopup.add(insertRow);
        this.dataModificationsPopup.add(removeLastRow);
    }

    private Object getLocalAddress() {
        try {
            return this.cache.getLocalAddress();
        }
        catch (Throwable t) {
            this.log.error((Object)"JBossCacheGUI.getLocalAddress(): ", t);
            return null;
        }
    }

    private void load(Fqn<String> fqn) {
        try {
            this.cache.getRoot().getChild(fqn);
        }
        catch (Throwable t) {
            this.log.error((Object)("JBossCacheGUI.load(): " + t));
        }
    }

    private List<Address> getMembers() {
        try {
            return new ArrayList<Address>(this.cache.getMembers());
        }
        catch (Throwable t) {
            this.log.error((Object)"TreeCacheGui.getMembers(): ", t);
            return null;
        }
    }

    private String[] getRowPlaceHolderData() {
        Collection keys = this.extractKeys(this.tableModel.getDataVector());
        int count = 0;
        String placeHolderKey = "{ --- Add Key --- }";
        while (keys.contains(placeHolderKey)) {
            placeHolderKey = "{ --- Add Key " + ++count + " --- }";
        }
        String placeHolderValue = "{ --- Add Value " + (count == 0 ? "" : Integer.valueOf(count)) + " --- }";
        return new String[]{placeHolderKey, placeHolderValue};
    }

    private boolean isPlaceHolder(String s) {
        if (s.startsWith("{ --- Add Key ") && s.endsWith(" --- }")) {
            return true;
        }
        return s.startsWith("{ --- Add Value ") && s.endsWith(" --- }");
    }

    private Collection extractKeys(Vector<Vector> v) {
        LinkedList l = new LinkedList();
        for (Vector row : v) {
            l.add(row.get(0));
        }
        return l;
    }

    private void printAndLogStacktrace(String message, Throwable t) {
        t.printStackTrace();
        this.log.error((Object)message, t);
    }

    void stopGui() {
        if (this.cache != null) {
            try {
                this.cache.stop();
                this.cache.destroy();
                this.cache = null;
            }
            catch (Throwable t) {
                this.printAndLogStacktrace("Stopping and destroying cache failed: ", t);
            }
        }
        this.dispose();
        System.exit(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DisplayNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 4882445905140460053L;
        String name = "<unnamed>";

        DisplayNode(String name) {
            this.name = name;
        }

        public DisplayNode add(Fqn<String> fqn) {
            DisplayNode ret = null;
            if (fqn == null) {
                return null;
            }
            DisplayNode curr = this;
            for (String child_name : fqn.peekElements()) {
                DisplayNode n = curr.findChild(child_name);
                if (n == null) {
                    n = new DisplayNode(child_name);
                    if (ret == null) {
                        ret = n;
                    }
                    curr.add(n);
                }
                curr = n;
            }
            return ret;
        }

        public void remove() {
            this.removeFromParent();
        }

        private DisplayNode findNode(Fqn<String> fqn) {
            if (fqn == null) {
                return null;
            }
            DisplayNode curr = this;
            for (String child_name : fqn.peekElements()) {
                DisplayNode n = curr.findChild(child_name);
                if (n == null) {
                    return null;
                }
                curr = n;
            }
            return curr;
        }

        private DisplayNode findChild(String relative_name) {
            if (relative_name == null || this.getChildCount() == 0) {
                return null;
            }
            for (int i = 0; i < this.getChildCount(); ++i) {
                DisplayNode child = (DisplayNode)this.getChildAt(i);
                if (child.name == null || !child.name.equals(relative_name)) continue;
                return child;
            }
            return null;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    class AddModifyDataForNodeAction
    extends AbstractAction {
        private static final long serialVersionUID = -7656592171312920825L;

        AddModifyDataForNodeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (JBossCacheGUI.this.log.isTraceEnabled()) {
                JBossCacheGUI.this.log.trace((Object)("node added/modified, updating GUI: " + e));
            }
            if (JBossCacheGUI.this.selected_node == null) {
                return;
            }
            JBossCacheGUI.this.clearTable();
            HashMap<String, String> data = JBossCacheGUI.this.selected_node.getData();
            if (data == null || data.isEmpty()) {
                data = new HashMap<String, String>();
                String[] placeHolder = JBossCacheGUI.this.getRowPlaceHolderData();
                data.put(placeHolder[0], placeHolder[1]);
            }
            JBossCacheGUI.this.populateTable(data);
            JBossCacheGUI.this.mainPanel.add((Component)JBossCacheGUI.this.tablePanel, "South");
            JBossCacheGUI.this.validate();
        }
    }

    class RemoveNodeAction
    extends AbstractAction {
        private static final long serialVersionUID = 3746013603940497991L;

        RemoveNodeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                JBossCacheGUI.this.cache.removeNode(JBossCacheGUI.this.selected_node.getFqn());
            }
            catch (Throwable t) {
                JBossCacheGUI.this.log.error((Object)("RemoveNodeAction.actionPerformed(): " + t));
            }
        }
    }

    class PrintLockInfoAction
    extends AbstractAction {
        private static final long serialVersionUID = -2171307516592250436L;

        PrintLockInfoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (JBossCacheGUI.this.bshConsole != null) {
                new Thread(){

                    public void run() {
                        JBossCacheGUI.this.bshConsole.getOut().println("\n*** lock information ****\n" + CachePrinter.printCacheLockingInfo((Cache)JBossCacheGUI.this.cache));
                    }
                }.start();
            } else {
                new Thread(){

                    public void run() {
                        System.out.println("\n*** lock information ****\n" + CachePrinter.printCacheLockingInfo((Cache)JBossCacheGUI.this.cache));
                    }
                }.start();
            }
        }
    }

    class RollbackTransaction
    extends AbstractAction {
        private static final long serialVersionUID = -4836748411400541430L;

        RollbackTransaction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (JBossCacheGUI.this.tx == null) {
                JBossCacheGUI.this.log.error((Object)"transaction is not running");
                return;
            }
            try {
                JBossCacheGUI.this.tx.rollback();
            }
            catch (Throwable t) {
                JBossCacheGUI.this.printAndLogStacktrace("Transaction rollback failed: ", t);
            }
            finally {
                JBossCacheGUI.this.tx = null;
            }
        }
    }

    class CommitTransaction
    extends AbstractAction {
        private static final long serialVersionUID = 5426108920883879873L;

        CommitTransaction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (JBossCacheGUI.this.tx == null) {
                JBossCacheGUI.this.log.error((Object)"transaction is not running");
                return;
            }
            try {
                JBossCacheGUI.this.tx.commit();
            }
            catch (Throwable t) {
                JBossCacheGUI.this.printAndLogStacktrace("Commiting transaction failed: ", t);
            }
            finally {
                JBossCacheGUI.this.tx = null;
            }
        }
    }

    class StartTransaction
    extends AbstractAction {
        private static final long serialVersionUID = 7059131008813144857L;

        StartTransaction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (JBossCacheGUI.this.tx_mgr == null) {
                JBossCacheGUI.this.log.error((Object)"no TransactionManager specified");
                return;
            }
            if (JBossCacheGUI.this.tx != null) {
                JBossCacheGUI.this.log.error((Object)("transaction is already running: " + JBossCacheGUI.this.tx));
                return;
            }
            try {
                JBossCacheGUI.this.tx_mgr.begin();
                JBossCacheGUI.this.tx = JBossCacheGUI.this.tx_mgr.getTransaction();
            }
            catch (Throwable t) {
                JBossCacheGUI.this.printAndLogStacktrace("Creating transaction failed: ", t);
            }
        }
    }

    class EvictAction
    extends AbstractAction {
        private static final long serialVersionUID = 6007500908549034215L;

        EvictAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTextField fqnTextField = new JTextField();
            if (JBossCacheGUI.this.selected_node != null) {
                fqnTextField.setText(JBossCacheGUI.this.selected_node.getFqn().toString());
            } else {
                fqnTextField.setText("/");
            }
            Object[] information = new Object[]{"Enter fully qualified name", fqnTextField};
            String btnString1 = "OK";
            String btnString2 = "Cancel";
            Object[] options = new Object[]{"OK", "Cancel"};
            int userChoice = JOptionPane.showOptionDialog(null, information, "Evict DataNode", 0, -1, null, options, options[0]);
            if (userChoice == 0) {
                String userInput = fqnTextField.getText();
                JBossCacheGUI.this.cache.evict(Fqn.fromString((String)userInput), true);
            }
        }
    }

    class LoadAction
    extends AbstractAction {
        private static final long serialVersionUID = -6998760732995584428L;

        LoadAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTextField fqnTextField = new JTextField();
            if (JBossCacheGUI.this.selected_node != null) {
                fqnTextField.setText(JBossCacheGUI.this.selected_node.getFqn().toString());
            } else {
                fqnTextField.setText("/");
            }
            Object[] information = new Object[]{"Enter fully qualified name", fqnTextField};
            String btnString1 = "OK";
            String btnString2 = "Cancel";
            Object[] options = new Object[]{"OK", "Cancel"};
            int userChoice = JOptionPane.showOptionDialog(null, information, "Load DataNode", 0, -1, null, options, options[0]);
            if (userChoice == 0) {
                String userInput = fqnTextField.getText();
                JBossCacheGUI.this.load((Fqn<String>)Fqn.fromString((String)userInput));
            }
        }
    }

    class AddNodeAction
    extends AbstractAction {
        private static final long serialVersionUID = 7084928639244438800L;

        AddNodeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTextField fqnTextField = new JTextField();
            if (JBossCacheGUI.this.selected_node != null) {
                fqnTextField.setText(JBossCacheGUI.this.selected_node.getFqn().toString());
            } else {
                fqnTextField.setText("/");
            }
            Object[] information = new Object[]{"Enter fully qualified name", fqnTextField};
            String btnString1 = "OK";
            String btnString2 = "Cancel";
            Object[] options = new Object[]{"OK", "Cancel"};
            int userChoice = JOptionPane.showOptionDialog(null, information, "Add DataNode", 0, -1, null, options, options[0]);
            if (userChoice == 0) {
                String userInput = fqnTextField.getText();
                JBossCacheGUI.this.cache.put(Fqn.fromString((String)userInput), null);
            }
        }
    }

    class RemoveLastRowAction
    extends AbstractAction {
        private static final long serialVersionUID = 7084928639244438800L;

        RemoveLastRowAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int lastRow = JBossCacheGUI.this.tableModel.getRowCount() - 1;
            if (lastRow > -1) {
                String keyToRemove = (String)JBossCacheGUI.this.tableModel.getValueAt(lastRow, 0);
                JBossCacheGUI.this.tableModel.removeRow(lastRow);
                JBossCacheGUI.this.selected_node.remove((Object)keyToRemove);
            }
        }
    }

    class InsertRowAction
    extends AbstractAction {
        private static final long serialVersionUID = 7084928639244438800L;

        InsertRowAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JBossCacheGUI.this.tableModel.addRow(JBossCacheGUI.this.getRowPlaceHolderData());
        }
    }

    class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = -5364163916172148038L;

        ExitAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JBossCacheGUI.this.stopGui();
        }
    }
}

