/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock.pessimistic;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, enabled=false)
public class ConcurrentPutRemoveTest {
    private TransactionManager tm;
    static int count = 0;
    private Cache cache;
    private final Log log = LogFactory.getLog(ConcurrentPutRemoveTest.class);
    private List<SeparateThread> threads;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = new DefaultCacheFactory().createCache(false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.READ_COMMITTED);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.getConfiguration().setLockAcquisitionTimeout(10000L);
        this.cache.start();
        this.tm = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        this.threads = new ArrayList<SeparateThread>();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(this.cache);
        for (SeparateThread st : this.threads) {
            st.interrupt();
            st.join();
        }
    }

    @Test(invocationCount=500, enabled=false)
    public void testLock() throws Exception {
        System.out.println("ConcurrentPutRemoveTest.testLock count = " + ++count);
        for (int x = 0; x < 2; ++x) {
            SeparateThread t = new SeparateThread(x);
            this.threads.add(t);
            t.start();
        }
        for (SeparateThread separateThread : this.threads) {
            separateThread.join();
            if (separateThread.getException() == null) continue;
            throw separateThread.getException();
        }
    }

    private class SeparateThread
    extends Thread {
        Exception e = null;
        private int num = 0;

        public SeparateThread(int num) {
            this.num = num;
        }

        public Exception getException() {
            return this.e;
        }

        public void run() {
            Thread.currentThread().setName("Thread:" + this.num);
            try {
                for (int x = 0; x < 1000; ++x) {
                    ConcurrentPutRemoveTest.this.tm.begin();
                    ConcurrentPutRemoveTest.this.log.warn((Object)("Before Remove (" + x + ")"));
                    ConcurrentPutRemoveTest.this.cache.removeNode(Fqn.fromString((String)"/a"));
                    ConcurrentPutRemoveTest.this.log.warn((Object)("After Remove (" + x + ")"));
                    ConcurrentPutRemoveTest.this.tm.commit();
                    ConcurrentPutRemoveTest.this.log.warn((Object)("Before Put (" + x + ")"));
                    ConcurrentPutRemoveTest.this.cache.put(Fqn.fromString((String)"/a/b/c/d"), (Object)("text" + x), (Object)"b");
                    ConcurrentPutRemoveTest.this.log.warn((Object)("After Put (" + x + ")"));
                }
            }
            catch (Exception e) {
                ConcurrentPutRemoveTest.this.log.error((Object)"*** error on a thread", (Throwable)e);
                this.e = e;
            }
        }
    }
}

