/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DataContainer;
import org.jboss.cache.DataContainerImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.util.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class RemoveOnTxTest {
    private CacheSPI cache;
    private DataContainerImpl dataContainer;

    @BeforeMethod
    protected void setUp() throws Exception {
        Configuration configuration = new Configuration();
        configuration.setCacheMode(Configuration.CacheMode.LOCAL);
        configuration.setTransactionManagerLookupClass("org.jboss.cache.transaction.GenericTransactionManagerLookup");
        configuration.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(configuration);
        this.dataContainer = (DataContainerImpl)TestingUtil.extractComponentRegistry((Cache)this.cache).getComponent(DataContainer.class);
    }

    @AfterMethod
    protected void tearDown() throws Exception {
        this.cache.stop();
        this.cache.destroy();
    }

    public void testFailure() throws Exception {
        TransactionManager tm = this.cache.getTransactionManager();
        try {
            tm.begin();
            this.print("put()");
            this.cache.put("/a/b/c", (Object)"test", (Object)"test");
            Assert.assertTrue((boolean)this.cache.get("/a/b/c", (Object)"test").equals("test"));
            this.print("remove()");
            this.cache.removeNode("/a/b");
            Assert.assertTrue((!this.cache.exists("/a/b") ? 1 : 0) != 0);
            Assert.assertTrue((!this.cache.exists("/a/b/c") ? 1 : 0) != 0);
            this.cache.put("/a/b/d", (Object)"test1", (Object)"test1");
            Assert.assertTrue((!this.cache.exists("/a/b/c") ? 1 : 0) != 0);
            Assert.assertTrue((boolean)this.cache.exists("/a/b/d"));
            this.print("Exists? " + this.cache.exists("/a/b/c"));
            this.print("get(): " + this.cache.get("/a/b/c", (Object)"test"));
            tm.commit();
            Assert.assertTrue((this.cache.peek(Fqn.fromString((String)"/a/b/c"), true, true) == null ? 1 : 0) != 0);
            Assert.assertTrue((!this.cache.exists("/a/b/c") ? 1 : 0) != 0);
            Assert.assertTrue((boolean)this.cache.exists("/a/b/d"));
            this.dataContainer.printLockInfo();
        }
        catch (Exception ex) {
            tm.rollback();
            throw ex;
        }
        this.dataContainer.printLockInfo();
        System.out.println(" lock info " + this.dataContainer.printLockInfo());
        try {
            tm.begin();
            this.print(this.cache.exists("/a/b/c"));
            this.print("get(): " + this.cache.get("/a/b/c", (Object)"test"));
            this.print("get(): " + this.cache.get("/a/b/c", (Object)"test"));
            Transaction t = tm.suspend();
            try {
                this.cache.putForExternalRead(Fqn.fromString((String)"/a/b/c"), (Object)"test", (Object)"test");
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
            tm.resume(t);
            this.print("get(): " + this.cache.get("/a/b/c", (Object)"test"));
            this.print(this.cache.exists("/a/b/c"));
            this.cache.put("/a/b/c", (Object)"test", (Object)"test");
            this.print(this.cache.exists("/a/b/c"));
            tm.commit();
        }
        catch (Exception ex) {
            tm.rollback();
            throw ex;
        }
    }

    private void print(Object s) {
        System.out.println(s);
    }

    private void print(boolean s) {
        System.out.println(s);
    }

    public void testReal() throws Exception {
        TransactionManager tm = this.cache.getTransactionManager();
        tm.begin();
        this.print("put()");
        this.cache.put("/a/b/c", (Object)"test", (Object)"test");
        Assert.assertTrue((boolean)this.cache.get("/a/b/c", (Object)"test").equals("test"));
        this.print("remove()");
        this.cache.removeNode("/a/b");
        Assert.assertTrue((!this.cache.exists("/a/b") ? 1 : 0) != 0);
        Assert.assertTrue((!this.cache.exists("/a/b/c") ? 1 : 0) != 0);
        this.cache.put("/a/b/d", (Object)"test1", (Object)"test1");
        Assert.assertTrue((!this.cache.exists("/a/b/c") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.cache.exists("/a/b/d"));
        this.print("Exists? " + this.cache.exists("/a/b/c"));
        this.print("get(): " + this.cache.get("/a/b/c", (Object)"test"));
        tm.commit();
        Assert.assertNull((Object)this.cache.peek(Fqn.fromString((String)"/a/b/c"), true, true));
        Assert.assertTrue((!this.cache.exists("/a/b/c") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.cache.exists("/a/b/d"));
        this.dataContainer.printLockInfo();
    }

    public void testSimplified() throws Exception {
        TransactionManager tm = this.cache.getTransactionManager();
        tm.begin();
        this.print("put()");
        this.cache.put("/a/b/c", (Object)"test", (Object)"test");
        Assert.assertTrue((this.cache.peek(Fqn.fromString((String)"/a/b/c"), true, true) != null ? 1 : 0) != 0);
        this.cache.removeNode("/a/b");
        tm.commit();
        Assert.assertTrue((this.cache.peek(Fqn.fromString((String)"/a/b/c"), true, true) == null ? 1 : 0) != 0);
    }
}

