package org.jboss.cache.pojo.test.propagation.impl;

import org.jboss.cache.pojo.test.propagation.Node;
import org.jboss.cache.pojo.test.propagation.PropagationRule;
import org.jboss.cache.pojo.test.propagation.StateItem;

import java.util.ArrayList;
import java.util.List;

public class NodeImpl implements Node
{
   private String rdn_;

   private String fdn_;

   private List<Node> childNodes_ = new ArrayList<Node>();

   private Node parentNode_;

   private List<StateItem> stateItems_ = new ArrayList<StateItem>();

   private StateItem summaryItem_;

   private transient PropagationRule rule_;

   public NodeImpl()
   {
      rule_ = PropagationRuleFactory.getPropagationRule();
   }

   public void setNodeRDN(String rdn)
   {
      this.rdn_ = rdn;
   }

   public String getNodeRDN()
   {
      return this.rdn_;
   }

   public void setNodeFDN(String fdn)
   {
      this.fdn_ = fdn;
   }

   public String getNodeFDN()
   {
      return this.fdn_;
   }

   public void addChildNode(Node child)
   {
      childNodes_.add(child);
   }

   public List<Node> getChildren()
   {
      return childNodes_;
   }

   public void setParentNode(Node parent)
   {
      parentNode_ = parent;
   }

   public Node getParentNode()
   {
      return this.parentNode_;
   }

   public void addStateItem(StateItem stateItem)
   {
      stateItems_.add(stateItem);
   }

   public void setSummaryStateItem(StateItem stateItem)
   {
      this.summaryItem_ = stateItem;
   }

   public StateItem getSummaryStateItem()
   {
      return this.summaryItem_;
   }

   public void setPropagationRule(PropagationRule rule)
   {
      this.rule_ = rule;
   }

   public PropagationRule getPropagationRule()
   {
      return rule_;
   }


   public List<StateItem> getStateItems()
   {
      return this.stateItems_;
   }

   public StateItem findStateItem(long itemId)
   {
      StateItem retItem = null;
      int size = stateItems_.size();
      for (int idx = 0; idx < size; idx++)
      {
         StateItem stateItem = stateItems_.get(idx);
         if (stateItem.getItemId() == itemId)
         {
            retItem = stateItem;
            break;
         }
      }

      return retItem;
   }

   public String toString()
   {
      return getNodeFDN();
   }
}
