/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.PointcutExpression;
import org.jboss.aop.pointcut.PointcutInfo;
import org.jboss.aop.pointcut.PointcutStats;
import org.jboss.aop.util.BindingClassifier;
import org.jboss.aop.util.UnmodifiableEmptyCollections;
import org.jboss.aop.util.UnmodifiableLinkedHashMap;
import org.jboss.aop.util.logging.AOPLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassifiedBindingAndPointcutCollection {
    private static final AOPLogger logger = AOPLogger.getLogger(AspectManager.class);
    private volatile LinkedHashMap<String, AdviceBinding> bindings = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
    private volatile Collection<AdviceBinding> fieldReadBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<AdviceBinding> fieldWriteBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<AdviceBinding> constructionBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<AdviceBinding> constructorExecutionBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<AdviceBinding> methodExecutionBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<AdviceBinding> constructorCallBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<AdviceBinding> methodCallBindings = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile LinkedHashMap<String, Pointcut> pointcuts = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
    private volatile Collection<Pointcut> fieldReadPointcuts = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<Pointcut> fieldWritePointcuts = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<Pointcut> constructionPointcuts = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<Pointcut> constructorExecutionPointcuts = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<Pointcut> methodExecutionPointcuts = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<Pointcut> constructorCallPointcuts = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<Pointcut> methodCallPointcuts = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile LinkedHashMap<String, PointcutInfo> pointcutInfos = UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP;
    private volatile Collection<PointcutInfo> fieldReadPointcutInfos = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<PointcutInfo> fieldWritePointcutInfos = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<PointcutInfo> constructionPointcutInfos = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<PointcutInfo> constructorExecutionPointcutInfos = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<PointcutInfo> methodExecutionPointcutInfos = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<PointcutInfo> constructorCallPointcutInfos = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private volatile Collection<PointcutInfo> methodCallPointcutInfos = UnmodifiableEmptyCollections.EMPTY_ARRAYLIST;
    private boolean execution = false;
    private boolean construction = false;
    private boolean call = false;
    private boolean within = false;
    private boolean get = false;
    private boolean set = false;
    private boolean withincode = false;

    public boolean hasPointcuts() {
        return this.pointcuts.size() > 0;
    }

    public Collection<AdviceBinding> getFieldReadBindings() {
        return this.fieldReadBindings;
    }

    public Collection<AdviceBinding> getFieldWriteBindings() {
        return this.fieldWriteBindings;
    }

    public Collection<AdviceBinding> getConstructionBindings() {
        return this.constructionBindings;
    }

    public Collection<AdviceBinding> getConstructorExecutionBindings() {
        return this.constructorExecutionBindings;
    }

    public Collection<AdviceBinding> getMethodExecutionBindings() {
        return this.methodExecutionBindings;
    }

    public Collection<AdviceBinding> getConstructorCallBindings() {
        return this.constructorCallBindings;
    }

    public Collection<AdviceBinding> getMethodCallBindings() {
        return this.methodCallBindings;
    }

    public Collection<Pointcut> getFieldReadPointcuts() {
        return this.fieldReadPointcuts;
    }

    public Collection<Pointcut> getFieldWritePointcuts() {
        return this.fieldWritePointcuts;
    }

    public Collection<Pointcut> getConstructionPointcuts() {
        return this.constructionPointcuts;
    }

    public Collection<Pointcut> getConstructorExecutionPointcuts() {
        return this.constructorExecutionPointcuts;
    }

    public Collection<Pointcut> getMethodExecutionPointcuts() {
        return this.methodExecutionPointcuts;
    }

    public Collection<Pointcut> getConstructorCallPointcuts() {
        return this.constructorCallPointcuts;
    }

    public Collection<Pointcut> getMethodCallPointcuts() {
        return this.methodCallPointcuts;
    }

    public Collection<PointcutInfo> getFieldReadPointcutInfos() {
        return this.fieldReadPointcutInfos;
    }

    public Collection<PointcutInfo> getFieldWritePointcutInfos() {
        return this.fieldWritePointcutInfos;
    }

    public Collection<PointcutInfo> getConstructionPointcutInfos() {
        return this.constructionPointcutInfos;
    }

    public Collection<PointcutInfo> getConstructorExecutionPointcutInfos() {
        return this.constructorExecutionPointcutInfos;
    }

    public Collection<PointcutInfo> getMethodExecutionPointcutInfos() {
        return this.methodExecutionPointcutInfos;
    }

    public Collection<PointcutInfo> getConstructorCallPointcutInfos() {
        return this.constructorCallPointcutInfos;
    }

    public Collection<PointcutInfo> getMethodCallPointcutInfos() {
        return this.methodCallPointcutInfos;
    }

    public boolean isEmpty() {
        return this.bindings.isEmpty();
    }

    public LinkedHashMap<String, AdviceBinding> getBindings() {
        return new UnmodifiableLinkedHashMap<String, AdviceBinding>(this.bindings);
    }

    @Deprecated
    public LinkedHashMap<String, AdviceBinding> getBindingsInternal() {
        return new UnmodifiableLinkedHashMap<String, AdviceBinding>(this.bindings);
    }

    public LinkedHashMap<String, Pointcut> getPointcuts() {
        return this.pointcuts;
    }

    @Deprecated
    public LinkedHashMap<String, Pointcut> getPointcutsInternal() {
        return this.pointcuts;
    }

    public LinkedHashMap<String, PointcutInfo> getPointcutInfos() {
        return new UnmodifiableLinkedHashMap<String, PointcutInfo>(this.pointcutInfos);
    }

    @Deprecated
    public LinkedHashMap<String, PointcutInfo> getPointcutInfosInternal() {
        return this.pointcutInfos;
    }

    public void add(AdviceBinding binding, AspectManager manager) {
        if (this.bindings == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
            this.bindings = new LinkedHashMap();
        }
        this.bindings.put(binding.getName(), binding);
        if (this.pointcuts == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
            this.pointcuts = new LinkedHashMap();
        }
        this.pointcuts.put(binding.getPointcut().getName(), binding.getPointcut());
        PointcutInfo pointcutInfo = new PointcutInfo(binding.getPointcut(), binding, AspectManager.hasTransformationStarted());
        if (this.pointcutInfos == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
            this.pointcutInfos = new LinkedHashMap();
        }
        this.pointcutInfos.put(pointcutInfo.getPointcut().getName(), pointcutInfo);
        this.addGet(binding, pointcutInfo);
        this.addSet(binding, pointcutInfo);
        this.addConstruction(binding, pointcutInfo);
        this.addConstructorExecution(binding, pointcutInfo);
        this.addMethodExecution(binding, pointcutInfo);
        this.addConstructorCall(binding, pointcutInfo);
        this.addMethodCall(binding, pointcutInfo);
        this.updatePointcutStats(binding.getPointcut(), manager);
    }

    public void add(Pointcut pointcut, AspectManager manager) {
        this.removePointcut(pointcut.getName());
        this.addPointcut(pointcut);
        this.updatePointcutStats(pointcut, manager);
    }

    public AdviceBinding removeBinding(String name) {
        AdviceBinding binding = (AdviceBinding)this.bindings.remove(name);
        if (binding != null) {
            this.removePointcut(binding.getPointcut());
            this.fieldReadBindings.remove(binding);
            this.fieldWriteBindings.remove(binding);
            this.constructionBindings.remove(binding);
            this.constructorExecutionBindings.remove(binding);
            this.methodExecutionBindings.remove(binding);
            this.constructorCallBindings.remove(binding);
            this.methodCallBindings.remove(binding);
        }
        return binding;
    }

    public void removePointcut(String name) {
        Pointcut pc = this.pointcuts.get(name);
        if (pc != null) {
            this.removePointcut(pc);
        }
    }

    public Pointcut getPointcut(String name) {
        return this.pointcuts.get(name);
    }

    public ArrayList<AdviceBinding> removeBindings(ArrayList<String> names) {
        ArrayList<AdviceBinding> removedBindings = new ArrayList<AdviceBinding>();
        for (String name : names) {
            AdviceBinding binding = this.removeBinding(name);
            if (binding == null) {
                logger.debug("ClassifiedBindingCollection.removeBindings() no binding found with name " + name);
                continue;
            }
            removedBindings.add(binding);
        }
        return removedBindings;
    }

    public boolean isExecution() {
        return this.execution;
    }

    public boolean isConstruction() {
        return this.construction;
    }

    public boolean isCall() {
        return this.call;
    }

    public boolean isWithin() {
        return this.within;
    }

    public boolean isWithincode() {
        return this.withincode;
    }

    public boolean isGet() {
        return this.get;
    }

    public boolean isSet() {
        return this.set;
    }

    private void addGet(AdviceBinding binding, PointcutInfo pointcutInfo) {
        if (BindingClassifier.isGet(binding)) {
            if (this.fieldReadBindings == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.fieldReadBindings = new CopyOnWriteArraySet<AdviceBinding>();
            }
            this.fieldReadBindings.add(binding);
            this.addFieldReadPointcut(pointcutInfo.getPointcut(), pointcutInfo);
        }
    }

    private void addSet(AdviceBinding binding, PointcutInfo pointcutInfo) {
        if (BindingClassifier.isSet(binding)) {
            if (this.fieldWriteBindings == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.fieldWriteBindings = new CopyOnWriteArraySet<AdviceBinding>();
            }
            this.fieldWriteBindings.add(binding);
            this.addFieldWritePointcut(pointcutInfo.getPointcut(), pointcutInfo);
        }
    }

    private void addConstruction(AdviceBinding binding, PointcutInfo pointcutInfo) {
        if (BindingClassifier.isConstruction(binding)) {
            if (this.constructionBindings == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.constructionBindings = new CopyOnWriteArraySet<AdviceBinding>();
            }
            this.constructionBindings.add(binding);
            this.addConstructionPointcut(pointcutInfo.getPointcut(), pointcutInfo);
        }
    }

    private void addConstructorExecution(AdviceBinding binding, PointcutInfo pointcutInfo) {
        if (BindingClassifier.isConstructorExecution(binding)) {
            if (this.constructorExecutionBindings == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.constructorExecutionBindings = new CopyOnWriteArraySet<AdviceBinding>();
            }
            this.constructorExecutionBindings.add(binding);
            this.addConstructorExecutionPointcut(pointcutInfo.getPointcut(), pointcutInfo);
        }
    }

    private void addMethodExecution(AdviceBinding binding, PointcutInfo pointcutInfo) {
        if (BindingClassifier.isMethodExecution(binding)) {
            if (this.methodExecutionBindings == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.methodExecutionBindings = new CopyOnWriteArraySet<AdviceBinding>();
            }
            this.methodExecutionBindings.add(binding);
            this.addMethodExecutionPointcut(pointcutInfo.getPointcut(), pointcutInfo);
        }
    }

    private void addMethodCall(AdviceBinding binding, PointcutInfo pointcutInfo) {
        if (BindingClassifier.isMethodCall(binding)) {
            if (this.methodCallBindings == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.methodCallBindings = new CopyOnWriteArraySet<AdviceBinding>();
            }
            this.methodCallBindings.add(binding);
            this.addMethodCallPointcut(pointcutInfo.getPointcut(), pointcutInfo);
        }
    }

    private void addConstructorCall(AdviceBinding binding, PointcutInfo pointcutInfo) {
        if (BindingClassifier.isConstructorCall(binding)) {
            if (this.constructorCallBindings == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.constructorCallBindings = new CopyOnWriteArraySet<AdviceBinding>();
            }
            this.constructorCallBindings.add(binding);
            this.addConstructorCallPointcut(pointcutInfo.getPointcut(), pointcutInfo);
        }
    }

    private void addPointcut(Pointcut pointcut) {
        if (this.pointcuts == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
            this.pointcuts = new LinkedHashMap();
        }
        this.pointcuts.put(pointcut.getName(), pointcut);
        if (this.pointcutInfos == UnmodifiableEmptyCollections.EMPTY_LINKED_HASHMAP) {
            this.pointcutInfos = new LinkedHashMap();
        }
        PointcutInfo info = new PointcutInfo(pointcut, AspectManager.hasTransformationStarted());
        this.pointcutInfos.put(pointcut.getName(), info);
        this.addFieldReadPointcut(pointcut, info);
        this.addFieldWritePointcut(pointcut, info);
        this.addConstructionPointcut(pointcut, info);
        this.addConstructorExecutionPointcut(pointcut, info);
        this.addMethodExecutionPointcut(pointcut, info);
        this.addConstructorCallPointcut(pointcut, info);
        this.addMethodCallPointcut(pointcut, info);
    }

    private void addFieldReadPointcut(Pointcut pointcut, PointcutInfo info) {
        if (BindingClassifier.isGet(pointcut)) {
            if (this.fieldReadPointcuts == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.fieldReadPointcuts = new CopyOnWriteArrayList<Pointcut>();
            }
            this.fieldReadPointcuts.add(pointcut);
            if (this.fieldReadPointcutInfos == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.fieldReadPointcutInfos = new CopyOnWriteArrayList<PointcutInfo>();
            }
            this.fieldReadPointcutInfos.add(info);
        }
    }

    private void addFieldWritePointcut(Pointcut pointcut, PointcutInfo info) {
        if (BindingClassifier.isSet(pointcut)) {
            if (this.fieldWritePointcuts == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.fieldWritePointcuts = new CopyOnWriteArrayList<Pointcut>();
            }
            this.fieldWritePointcuts.add(pointcut);
            if (this.fieldWritePointcutInfos == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.fieldWritePointcutInfos = new CopyOnWriteArrayList<PointcutInfo>();
            }
            this.fieldWritePointcutInfos.add(info);
        }
    }

    private void addConstructionPointcut(Pointcut pointcut, PointcutInfo info) {
        if (BindingClassifier.isConstruction(pointcut)) {
            if (this.constructionPointcuts == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.constructionPointcuts = new CopyOnWriteArrayList<Pointcut>();
            }
            this.constructionPointcuts.add(pointcut);
            if (this.constructionPointcutInfos == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.constructionPointcutInfos = new CopyOnWriteArrayList<PointcutInfo>();
            }
            this.constructionPointcutInfos.add(info);
        }
    }

    private void addConstructorExecutionPointcut(Pointcut pointcut, PointcutInfo info) {
        if (BindingClassifier.isConstructorExecution(pointcut)) {
            if (this.constructorExecutionPointcuts == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.constructorExecutionPointcuts = new CopyOnWriteArrayList<Pointcut>();
            }
            this.constructorExecutionPointcuts.add(pointcut);
            if (this.constructorExecutionPointcutInfos == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.constructorExecutionPointcutInfos = new CopyOnWriteArrayList<PointcutInfo>();
            }
            this.constructorExecutionPointcutInfos.add(info);
        }
    }

    private void addMethodExecutionPointcut(Pointcut pointcut, PointcutInfo info) {
        if (BindingClassifier.isMethodExecution(pointcut)) {
            if (this.methodExecutionPointcuts == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.methodExecutionPointcuts = new CopyOnWriteArrayList<Pointcut>();
            }
            this.methodExecutionPointcuts.add(pointcut);
            if (this.methodExecutionPointcutInfos == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.methodExecutionPointcutInfos = new CopyOnWriteArrayList<PointcutInfo>();
            }
            this.methodExecutionPointcutInfos.add(info);
        }
    }

    private void addConstructorCallPointcut(Pointcut pointcut, PointcutInfo info) {
        if (BindingClassifier.isConstructorCall(pointcut)) {
            if (this.constructorCallPointcuts == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.constructorCallPointcuts = new CopyOnWriteArrayList<Pointcut>();
            }
            this.constructorCallPointcuts.add(pointcut);
            if (this.constructorCallPointcutInfos == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.constructorCallPointcutInfos = new CopyOnWriteArrayList<PointcutInfo>();
            }
            this.constructorCallPointcutInfos.add(info);
        }
    }

    private void addMethodCallPointcut(Pointcut pointcut, PointcutInfo info) {
        if (BindingClassifier.isMethodCall(pointcut)) {
            if (this.methodCallPointcuts == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.methodCallPointcuts = new CopyOnWriteArrayList<Pointcut>();
            }
            this.methodCallPointcuts.add(pointcut);
            if (this.methodCallPointcutInfos == UnmodifiableEmptyCollections.EMPTY_ARRAYLIST) {
                this.methodCallPointcutInfos = new CopyOnWriteArrayList<PointcutInfo>();
            }
            this.methodCallPointcutInfos.add(info);
        }
    }

    public void removePointcut(Pointcut pc) {
        this.pointcuts.remove(pc.getName());
        this.fieldReadPointcuts.remove(pc);
        this.fieldWritePointcuts.remove(pc);
        this.constructionPointcuts.remove(pc);
        this.constructorExecutionPointcuts.remove(pc);
        this.methodExecutionPointcuts.remove(pc);
        this.constructorCallPointcuts.remove(pc);
        this.methodCallPointcuts.remove(pc);
        PointcutInfo info = (PointcutInfo)this.pointcutInfos.remove(pc.getName());
        this.fieldReadPointcutInfos.remove(info);
        this.fieldWritePointcutInfos.remove(info);
        this.constructionPointcutInfos.remove(info);
        this.constructorExecutionPointcutInfos.remove(info);
        this.methodExecutionPointcutInfos.remove(info);
        this.constructorCallPointcutInfos.remove(info);
        this.methodCallPointcutInfos.remove(info);
    }

    private void updatePointcutStats(Pointcut pointcut, AspectManager manager) {
        if (pointcut instanceof PointcutExpression) {
            PointcutExpression expr = (PointcutExpression)pointcut;
            expr.setManager(manager);
            PointcutStats stats = expr.getStats();
            this.updateStats(stats);
        } else {
            this.execution = true;
            this.construction = true;
            this.call = true;
            this.within = true;
            this.get = true;
            this.set = true;
            this.withincode = true;
        }
    }

    public void updateStats(PointcutStats stats) {
        if (stats != null) {
            this.construction |= stats.isConstruction();
            this.execution |= stats.isExecution();
            this.call |= stats.isCall();
            this.within |= stats.isWithin();
            this.get |= stats.isGet();
            this.set |= stats.isSet();
            this.withincode |= stats.isWithincode();
        } else {
            if (AspectManager.verbose && logger.isDebugEnabled()) {
                logger.debug("Setting all pointcut stats to true");
            }
            this.execution = true;
            this.construction = true;
            this.call = true;
            this.within = true;
            this.get = true;
            this.set = true;
            this.withincode = true;
        }
    }
}

