/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.mvcc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.invocation.NodeInvocationDelegate;
import org.jboss.cache.mvcc.NodeReference;

public class ReadCommittedNode
extends NodeInvocationDelegate {
    private static final Log log = LogFactory.getLog(ReadCommittedNode.class);
    private static final boolean trace = log.isTraceEnabled();
    protected volatile InternalNode backup;
    protected byte flags = 0;
    protected InternalNode parent;

    public ReadCommittedNode(InternalNode node, InternalNode parent) {
        super(node);
        this.parent = parent;
    }

    public InternalNode getInternalParent() {
        return this.parent;
    }

    protected final boolean isFlagSet(Flags flag) {
        return (this.flags & flag.mask) != 0;
    }

    protected final void setFlag(Flags flag) {
        this.flags = (byte)(this.flags | flag.mask);
    }

    protected final void unsetFlag(Flags flag) {
        this.flags = (byte)(this.flags & ~flag.mask);
    }

    public boolean isNullNode() {
        return false;
    }

    public void markForUpdate(DataContainer container, boolean writeSkewCheck) {
        if (this.isFlagSet(Flags.CHANGED)) {
            return;
        }
        this.setFlag(Flags.CHANGED);
        if (!this.isFlagSet(Flags.CREATED)) {
            this.backup = this.node;
            InternalNode backupDelegationTarget = ((NodeReference)this.backup).getDelegate();
            this.node = backupDelegationTarget.copy();
        }
    }

    public void commitUpdate(InvocationContext ctx, DataContainer container) {
        if (this.isFlagSet(Flags.CHANGED)) {
            Fqn fqn = this.getFqn();
            if (trace) {
                log.trace((Object)("Updating node [" + fqn + "].  deleted=" + this.isDeleted() + " valid=" + this.isValid() + " changed=" + this.isChanged() + " created=" + this.isFlagSet(Flags.CREATED)));
            }
            if (this.isFlagSet(Flags.DELETED)) {
                if (!fqn.isRoot()) {
                    InternalNode parent = this.lookupParent(fqn, ctx, container);
                    parent.removeChild(fqn.getLastElement());
                    this.setValid(false, false);
                    this.updateNode(fqn, ctx, container);
                } else {
                    log.warn((Object)"Attempting to remove the root node.  Not doing anything!");
                }
            } else if (this.isFlagSet(Flags.CREATED)) {
                InternalNode parent = this.lookupParent(fqn, ctx, container);
                parent.addChild(this.node, true);
            } else {
                this.updateNode(fqn, ctx, container);
            }
            this.reset();
        }
    }

    private void reset() {
        this.backup = null;
        this.flags = 0;
    }

    protected final InternalNode lookupParent(Fqn fqn, InvocationContext ctx, DataContainer container) throws NodeNotExistsException {
        if (this.parent != null) {
            return this.parent;
        }
        Fqn parentFqn = fqn.getParent();
        NodeSPI parent = ctx.lookUpNode(parentFqn);
        InternalNode retval = parent != null ? parent.getDelegationTarget() : container.peekInternalNode(parentFqn, false);
        if (retval == null) {
            throw new NodeNotExistsException("Node " + parentFqn + " cannot be found in any context or data container!");
        }
        return retval;
    }

    protected void updateNode(Fqn fqn, InvocationContext ctx, DataContainer dataContainer) {
        if (!this.isFlagSet(Flags.CREATED)) {
            ((NodeReference)this.backup).setDelegate(this.node);
        }
        this.node = this.backup;
    }

    public void rollbackUpdate() {
        this.node = this.backup;
        this.reset();
    }

    public boolean isChanged() {
        return this.isFlagSet(Flags.CHANGED);
    }

    public boolean isCreated() {
        return this.isFlagSet(Flags.CREATED);
    }

    public void setCreated(boolean created) {
        if (created) {
            this.setFlag(Flags.CREATED);
        } else {
            this.unsetFlag(Flags.CREATED);
        }
    }

    public boolean isDeleted() {
        return this.isFlagSet(Flags.DELETED);
    }

    public void markAsDeleted(boolean deleted) {
        if (deleted) {
            this.setFlag(Flags.DELETED);
        } else {
            this.unsetFlag(Flags.DELETED);
        }
    }

    public void markAsDeleted(boolean deleted, boolean recursive) {
        throw new UnsupportedOperationException("Recursive deletion not allowed!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Flags {
        CHANGED(1),
        CREATED(2),
        DELETED(4);

        final byte mask;

        private Flags(int mask) {
            this.mask = (byte)mask;
        }
    }
}

