/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util.concurrent.locks;

import java.util.concurrent.locks.Lock;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class LockContainer<E> {
    private int lockSegmentMask;
    private int lockSegmentShift;

    protected int calculateNumberOfSegments(int concurrencyLevel) {
        int numLocks;
        int tempLockSegShift = 0;
        for (numLocks = 1; numLocks < concurrencyLevel; numLocks <<= 1) {
            ++tempLockSegShift;
        }
        this.lockSegmentShift = 32 - tempLockSegShift;
        this.lockSegmentMask = numLocks - 1;
        return numLocks;
    }

    public final int hashToIndex(E object) {
        return this.hash(object) >>> this.lockSegmentShift & this.lockSegmentMask;
    }

    final int hash(E object) {
        int h = object.hashCode();
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        h ^= h >>> 16;
        return h;
    }

    protected abstract void initLocks(int var1);

    public abstract boolean ownsLock(E var1, Object var2);

    public abstract boolean isLocked(E var1);

    public abstract Lock getLock(E var1);

    public abstract int getNumLocksHeld();

    public abstract void reset();

    public abstract int size();
}

