/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    private static final Log log = LogFactory.getLog(ReflectionUtil.class);

    public static List<Method> getAllMethods(Class c, Class<? extends Annotation> annotationType) {
        LinkedList<Method> annotated = new LinkedList<Method>();
        ReflectionUtil.inspectRecursively(c, annotated, annotationType);
        return annotated;
    }

    private static void inspectRecursively(Class c, List<Method> s, Class<? extends Annotation> annotationType) {
        if (!c.equals(Object.class)) {
            ReflectionUtil.inspectRecursively(c.getSuperclass(), s, annotationType);
        }
        for (Method m : c.getDeclaredMethods()) {
            if (ReflectionUtil.alreadyFound(m, s) || !m.isAnnotationPresent(annotationType)) continue;
            s.add(m);
        }
    }

    private static boolean alreadyFound(Method m, Collection<Method> s) {
        for (Method found : s) {
            if (!m.getName().equals(found.getName()) || !Arrays.equals(m.getParameterTypes(), found.getParameterTypes())) continue;
            return true;
        }
        return false;
    }

    public static void setValue(Object instance, String fieldName, Object value) {
        try {
            Field f = ReflectionUtil.findFieldRecursively(instance.getClass(), fieldName);
            if (f == null) {
                throw new NoSuchMethodException("Cannot find field " + fieldName + " on " + instance.getClass() + " or superclasses");
            }
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (Exception e) {
            log.error((Object)"Unable to set value!", (Throwable)e);
        }
    }

    private static Field findFieldRecursively(Class c, String fieldName) {
        Field f;
        block2: {
            f = null;
            try {
                f = c.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                if (c.equals(Object.class)) break block2;
                f = ReflectionUtil.findFieldRecursively(c.getSuperclass(), fieldName);
            }
        }
        return f;
    }

    public static void invokeAccessibly(Object instance, Method method, Object[] parameters) {
        try {
            method.setAccessible(true);
            method.invoke(instance, parameters);
        }
        catch (Exception e) {
            throw new CacheException("Unable to invoke method " + method + " on object " + (parameters != null ? " with parameters " + Arrays.asList(parameters) : ""), e);
        }
    }
}

