/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.parsing.XmlConfigurationParser;
import org.jboss.cache.config.parsing.XmlConfigurationParser2x;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.util.TestingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitTestCacheFactory<K, V>
implements CacheFactory<K, V> {
    private final Log log = LogFactory.getLog(UnitTestCacheFactory.class);
    private static final ThreadLocal<String> threadMcastIP = new ThreadLocal<String>(){
        private final AtomicInteger uniqueAddr = new AtomicInteger(11);

        @Override
        protected String initialValue() {
            return "228.10.10." + this.uniqueAddr.getAndIncrement();
        }
    };
    private static final ThreadLocal<Integer> threadMcastPort = new ThreadLocal<Integer>(){
        private final AtomicInteger uniquePort = new AtomicInteger(45589);

        @Override
        protected Integer initialValue() {
            return this.uniquePort.getAndIncrement();
        }
    };
    private static final ThreadLocal<List<Cache>> threadCaches = new ThreadLocal<List<Cache>>(){

        @Override
        protected List<Cache> initialValue() {
            return new ArrayList<Cache>();
        }
    };
    private static final List<Cache> allCaches = new ArrayList<Cache>();
    private static final ThreadLocal<String> threadTestName = new ThreadLocal();

    public Cache<K, V> createCache() throws ConfigurationException {
        return this.createCache(true);
    }

    public Cache<K, V> createCache(boolean start) throws ConfigurationException {
        return this.createCache(new Configuration(), start);
    }

    public Cache<K, V> createCache(String configFileName) throws ConfigurationException {
        return this.createCache(configFileName, true);
    }

    public Cache<K, V> createCache(String configFileName, boolean start) throws ConfigurationException {
        Configuration c;
        XmlConfigurationParser parser = new XmlConfigurationParser();
        try {
            c = parser.parseFile(configFileName);
        }
        catch (ConfigurationException e) {
            System.out.println("Detected legacy configuration file format when parsing [" + configFileName + "].  Migrating to the new (3.x) file format is recommended.  See FAQs for details.");
            XmlConfigurationParser2x oldParser = new XmlConfigurationParser2x();
            c = oldParser.parseFile(configFileName);
        }
        return this.createCache(c, start);
    }

    public Cache<K, V> createCache(Configuration configuration) throws ConfigurationException {
        return this.createCache(configuration, true);
    }

    public Cache<K, V> createCache(InputStream is) throws ConfigurationException {
        return this.createCache(is, true);
    }

    public Cache<K, V> createCache(InputStream is, boolean start) throws ConfigurationException {
        XmlConfigurationParser parser = new XmlConfigurationParser();
        Configuration c = parser.parseStream(is);
        return this.createCache(c, start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache<K, V> createCache(Configuration configuration, boolean start) throws ConfigurationException {
        this.checkCaches();
        switch (configuration.getCacheMode()) {
            case LOCAL: {
                break;
            }
            case REPL_SYNC: 
            case REPL_ASYNC: 
            case INVALIDATION_ASYNC: 
            case INVALIDATION_SYNC: {
                this.mangleConfiguration(configuration);
                break;
            }
            default: {
                this.log.info((Object)"Unknown cache mode!");
            }
        }
        Cache cache = new DefaultCacheFactory().createCache(configuration, start);
        List<Cache> caches = threadCaches.get();
        caches.add(cache);
        List<Cache> list = allCaches;
        synchronized (list) {
            allCaches.add(cache);
        }
        return cache;
    }

    public boolean cleanUp() {
        ArrayList caches = new ArrayList(threadCaches.get());
        boolean ret = false;
        for (Cache cache : caches) {
            TestingUtil.killCaches(cache);
            ret = true;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCache(Cache c) {
        List<Cache> caches = threadCaches.get();
        List<Cache> list = allCaches;
        synchronized (list) {
            if (caches.contains(c)) {
                caches.remove(c);
                allCaches.remove(c);
            } else if (allCaches.contains(c)) {
                System.out.println("[" + Thread.currentThread().getName() + "] WARNING!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! Remove cache called from different thread.");
                Thread.dumpStack();
            }
        }
    }

    public void mangleConfiguration(Configuration configuration) {
        StackTraceElement[] traceElements = Thread.getAllStackTraces().get(Thread.currentThread());
        Class<?> clazz = null;
        for (StackTraceElement traceElement : traceElements) {
            String className = traceElement.getClassName();
            if (className.startsWith("java.lang.Thread") || !className.startsWith("org.jboss")) continue;
            try {
                clazz = Class.forName(traceElement.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new Error(traceElement.getClassName() + " should be in class path");
            }
        }
        System.out.println("Test class is = " + clazz);
        configuration.setClusterConfig(this.mangleClusterConfiguration(configuration.getClusterConfig()));
        String clusterName = configuration.getClusterName();
        if (clusterName.indexOf(Thread.currentThread().getName()) == -1) {
            clusterName = clusterName + "-" + Thread.currentThread().getName();
        }
        configuration.setClusterName(clusterName);
    }

    public String mangleClusterConfiguration(String clusterConfig) {
        Pattern pattern;
        Matcher m;
        if (clusterConfig == null) {
            clusterConfig = UnitTestCacheConfigurationFactory.getClusterConfigFromFile(new Configuration().getDefaultClusterConfig());
        }
        if ((m = (pattern = Pattern.compile("mcast_addr=[^;]*")).matcher(clusterConfig)).find()) {
            String origAddr = m.group().substring(m.group().indexOf("=") + 1);
            String newAddr = threadMcastIP.get();
            clusterConfig = m.replaceFirst("mcast_addr=" + newAddr);
        } else {
            Thread.dumpStack();
            System.exit(1);
        }
        pattern = Pattern.compile("mcast_port=[^;]*");
        m = pattern.matcher(clusterConfig);
        if (m.find()) {
            String newPort = threadMcastPort.get().toString();
            clusterConfig = m.replaceFirst("mcast_port=" + newPort);
        }
        return clusterConfig;
    }

    private void checkCaches() {
        String lastTestName = threadTestName.get();
        String currentTestName = this.extractTestName();
        if (lastTestName != null && !lastTestName.equals(currentTestName)) {
            String threadId = "[" + Thread.currentThread().getName() + "] ";
            if (this.cleanUp()) {
                System.out.print(threadId + "WARNING!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! ");
                System.out.print(threadId + " A test method in " + lastTestName + " did not clean all cache instances properly. ");
                System.out.println(threadId + " Use UnitTestCacheFactory.cleanUp() or TestngUtil.killCaches(...) ");
            }
        }
        threadTestName.set(currentTestName);
    }

    private String extractTestName() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length == 0) {
            return null;
        }
        for (int i = stack.length - 1; i > 0; --i) {
            StackTraceElement e = stack[i];
            String className = e.getClassName();
            if (className.indexOf("org.jboss.cache") == -1) continue;
            return className;
        }
        return null;
    }
}

