/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api;

import java.util.HashMap;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups", "pessimistic"}, sequential=true)
public class SyncReplTest {
    private CacheSPI<Object, Object> cache1;
    private CacheSPI<Object, Object> cache2;
    protected Configuration.NodeLockingScheme nodeLockingScheme = Configuration.NodeLockingScheme.PESSIMISTIC;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        System.out.println("*** In setUp()");
        this.cache1 = (CacheSPI)new UnitTestCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC), false);
        this.cache2 = (CacheSPI)new UnitTestCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC), false);
        this.cache1.getConfiguration().setNodeLockingScheme(this.nodeLockingScheme);
        this.cache2.getConfiguration().setNodeLockingScheme(this.nodeLockingScheme);
        this.configure(this.cache1.getConfiguration());
        this.configure(this.cache2.getConfiguration());
        this.cache1.start();
        this.cache2.start();
        TestingUtil.blockUntilViewsReceived(new Cache[]{this.cache1, this.cache2}, 5000L);
        System.out.println("*** Finished setUp()");
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache1, this.cache2});
        this.cache1 = null;
        this.cache2 = null;
    }

    protected void configure(Configuration c) {
    }

    public void testBasicOperation() {
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        this.assertInvocationContextInitState();
        Fqn f = Fqn.fromString((String)"/test/data");
        String k = "key";
        String v = "value";
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache1.getRoot().getChild(f));
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache2.getRoot().getChild(f));
        Node node = this.cache1.getRoot().addChild(f);
        AssertJUnit.assertNotNull((String)"Should not be null", (Object)node);
        node.put((Object)k, (Object)v);
        AssertJUnit.assertEquals((Object)v, (Object)node.get((Object)k));
        AssertJUnit.assertEquals((Object)v, (Object)this.cache1.get(f, (Object)k));
        AssertJUnit.assertEquals((String)"Should have replicated", (Object)v, (Object)this.cache2.get(f, (Object)k));
    }

    public void testSyncRepl() {
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        this.assertInvocationContextInitState();
        Fqn fqn = Fqn.fromString((String)"/JSESSIONID/1010.10.5:3000/1234567890/1");
        this.cache1.getConfiguration().setSyncCommitPhase(true);
        this.cache2.getConfiguration().setSyncCommitPhase(true);
        this.cache1.put(fqn, (Object)"age", (Object)38);
        AssertJUnit.assertEquals((String)"Value should be set", (Object)38, (Object)this.cache1.get(fqn, (Object)"age"));
        AssertJUnit.assertEquals((String)"Value should have replicated", (Object)38, (Object)this.cache2.get(fqn, (Object)"age"));
    }

    public void testPutMap() {
        this.assertClusterSize("Should only be 2  caches in the cluster!!!", 2);
        this.assertInvocationContextInitState();
        Fqn fqn = Fqn.fromString((String)"/JSESSIONID/10.10.10.5:3000/1234567890/1");
        Fqn fqn1 = Fqn.fromString((String)"/JSESSIONID/10.10.10.5:3000/1234567890/2");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "1");
        map.put("2", "2");
        this.cache1.getInvocationContext().getOptionOverrides().setSuppressLocking(true);
        this.cache1.getRoot().addChild(fqn).putAll(map);
        this.cache1.getInvocationContext().getOptionOverrides().setSuppressLocking(true);
        AssertJUnit.assertEquals((String)"Value should be set", (Object)"1", (Object)this.cache1.get(fqn, (Object)"1"));
        map = new HashMap();
        map.put("3", "3");
        map.put("4", "4");
        this.cache1.getInvocationContext().getOptionOverrides().setSuppressLocking(true);
        this.cache1.getRoot().addChild(fqn1).putAll(map);
        this.cache1.getInvocationContext().getOptionOverrides().setSuppressLocking(true);
        AssertJUnit.assertEquals((String)"Value should be set", (Object)"2", (Object)this.cache1.get(fqn, (Object)"2"));
    }

    private void assertClusterSize(String message, int size) {
        this.assertClusterSize(message, size, (Cache)this.cache1);
        this.assertClusterSize(message, size, (Cache)this.cache2);
    }

    private void assertClusterSize(String message, int size, Cache c) {
        AssertJUnit.assertEquals((String)message, (int)size, (int)c.getMembers().size());
    }

    private void assertInvocationContextInitState() {
        this.assertInvocationContextInitState((Cache)this.cache1);
        this.assertInvocationContextInitState((Cache)this.cache2);
    }

    private void assertInvocationContextInitState(Cache c) {
        InvocationContext ctx = c.getInvocationContext();
        InvocationContext control = ctx.copy();
        control.reset();
        AssertJUnit.assertEquals((String)"Should be equal", (Object)control, (Object)ctx);
    }
}

