/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.batch;

import org.jboss.cache.Cache;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.api.batch.AbstractBatchTest;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class BatchWithoutTM
extends AbstractBatchTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchWithoutCfg() {
        Cache<String, String> cache = null;
        try {
            cache = this.createCache(false);
            try {
                cache.startBatch();
                assert (false) : "Should have failed";
            }
            catch (ConfigurationException good) {
                // empty catch block
            }
            try {
                cache.endBatch(true);
                assert (false) : "Should have failed";
            }
            catch (ConfigurationException good) {
                // empty catch block
            }
            try {
                cache.endBatch(false);
                assert (false) : "Should have failed";
            }
            catch (ConfigurationException configurationException) {
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            TestingUtil.killCaches(cache);
            cache = null;
            throw throwable;
        }
        TestingUtil.killCaches(cache);
        cache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEndBatchWithoutStartBatch() {
        Cache<String, String> cache = null;
        try {
            cache = this.createCache(true);
            cache.endBatch(true);
            cache.endBatch(false);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            TestingUtil.killCaches(cache);
            throw throwable;
        }
        TestingUtil.killCaches(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStartBatchIdempotency() {
        Cache<String, String> cache = null;
        try {
            cache = this.createCache(true);
            cache.startBatch();
            cache.put("/a/b/c", (Object)"k", (Object)"v");
            cache.startBatch();
            cache.put("/a/b/c", (Object)"k2", (Object)"v2");
            cache.endBatch(true);
            assert ("v".equals(cache.get("/a/b/c", (Object)"k")));
            assert ("v2".equals(cache.get("/a/b/c", (Object)"k2")));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            TestingUtil.killCaches(cache);
            cache = null;
            throw throwable;
        }
        TestingUtil.killCaches(cache);
        cache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchVisibility() throws InterruptedException {
        Cache<String, String> cache = null;
        try {
            cache = this.createCache(true);
            cache.startBatch();
            cache.put("/a/b/c", (Object)"k", (Object)"v");
            assert (this.getOnDifferentThread(cache, "/a/b/c", "k") == null) : "Other thread should not see batch update till batch completes!";
            cache.endBatch(true);
            assert ("v".equals(this.getOnDifferentThread(cache, "/a/b/c", "k")));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            TestingUtil.killCaches(cache);
            cache = null;
            throw throwable;
        }
        TestingUtil.killCaches(cache);
        cache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchRollback() throws Exception {
        Cache<String, String> cache = null;
        try {
            cache = this.createCache(true);
            cache.startBatch();
            cache.put("/a/b/c", (Object)"k", (Object)"v");
            cache.put("/a/b/c", (Object)"k2", (Object)"v2");
            assert (this.getOnDifferentThread(cache, "/a/b/c", "k") == null);
            assert (this.getOnDifferentThread(cache, "/a/b/c", "k2") == null);
            cache.endBatch(false);
            assert (this.getOnDifferentThread(cache, "/a/b/c", "k") == null);
            assert (this.getOnDifferentThread(cache, "/a/b/c", "k2") == null);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            TestingUtil.killCaches(cache);
            cache = null;
            throw throwable;
        }
        TestingUtil.killCaches(cache);
        cache = null;
    }

    private Cache<String, String> createCache(boolean enableBatch) {
        UnitTestCacheFactory cf = new UnitTestCacheFactory();
        Configuration c = new Configuration();
        c.setNodeLockingScheme(Configuration.NodeLockingScheme.MVCC);
        c.setInvocationBatchingEnabled(enableBatch);
        return cf.createCache(c);
    }
}

