/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.mvcc;

import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.lock.LockType;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "mvcc"})
public class ForceWriteLockTest
extends org.jboss.cache.options.ForceWriteLockTest {
    public ForceWriteLockTest() {
        this.nodeLockingScheme = Configuration.NodeLockingScheme.MVCC;
    }

    protected void assertNotLocked(Fqn fqn) {
        assert (!TestingUtil.extractLockManager((Cache)this.cache).isLocked(this.cache.peek(fqn, true))) : "Node " + fqn + " is locked!!";
    }

    protected void assertLocked(Object owner, Fqn fqn, boolean write_locked) {
        if (write_locked) {
            LockManager lm = TestingUtil.extractLockManager((Cache)this.cache);
            NodeSPI n = this.cache.peek(fqn, true);
            if (owner == null) {
                owner = Thread.currentThread();
            }
            AssertJUnit.assertTrue((String)("node " + fqn + " is not locked"), (boolean)lm.isLocked(n));
            AssertJUnit.assertTrue((String)("node " + fqn + " is not write-locked by owner " + owner), (boolean)lm.ownsLock(fqn, LockType.WRITE, owner));
        }
    }
}

