/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.nodevalidity;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.api.nodevalidity.InvalidatedPessNodeValidityTest;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.testng.annotations.Test;

@Test(groups={"functional", "optimistic"})
public class InvalidatedOptNodeValidityTest
extends InvalidatedPessNodeValidityTest {
    public InvalidatedOptNodeValidityTest() {
        this.nodeLockingScheme = Configuration.NodeLockingScheme.OPTIMISTIC;
    }

    public void testTombstoneRevival() {
        Cache observer = (Cache)this.observerTL.get();
        Cache modifier = (Cache)this.modifierTL.get();
        modifier.put(parent, (Object)"k", (Object)"v");
        modifier.removeNode(parent);
        NodeSPI observerNode = (NodeSPI)observer.getRoot().getChild(parent);
        assert (observerNode == null) : "Should be removed";
        modifier.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)new DefaultDataVersion(10L));
        modifier.put(parent, (Object)"k", (Object)"v");
        NodeSPI modifierNode = (NodeSPI)modifier.getRoot().getChild(parent);
        assert (modifierNode != null) : "Should not be null";
        assert (modifierNode.isValid()) : "No longer a tombstone";
        assert (((DefaultDataVersion)modifierNode.getVersion()).getRawVersion() == 10L) : "Version should be updated";
        observerNode = (NodeSPI)observer.getRoot().getChild(parent);
        assert (observerNode != null) : "Should not be null";
        assert (observerNode.isValid()) : "No longer a tombstone";
        assert (((DefaultDataVersion)observerNode.getVersion()).getRawVersion() == 10L) : "Version should be updated";
    }

    public void testTombstoneVersioningFailure() throws Exception {
        Cache observer = (Cache)this.observerTL.get();
        Cache modifier = (Cache)this.modifierTL.get();
        CacheSPI modifierImpl = (CacheSPI)modifier;
        CacheSPI observerImpl = (CacheSPI)observer;
        modifier.put(parent, (Object)"k", (Object)"v");
        DummyInMemoryCacheLoader loader = (DummyInMemoryCacheLoader)((Object)this.loaderTL.get());
        assert (loader.get(parent) != null);
        assert (loader.get(parent).size() > 0);
        modifier.removeNode(parent);
        assert (modifierImpl.peek(parent, true, true) != null);
        assert (observerImpl.peek(parent, true, true) != null);
        assert (modifierImpl.peek(parent, false, false) == null);
        assert (observerImpl.peek(parent, false, false) == null);
        assert (loader.get(parent) == null);
        NodeSPI observerNode = (NodeSPI)observer.getRoot().getChild(parent);
        assert (observerNode == null) : "Should be removed";
        modifier.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)new DefaultDataVersion(1L));
        try {
            modifier.put(parent, (Object)"k", (Object)"v");
            assert (false) : "Should have barfed!";
        }
        catch (RuntimeException expected) {
            // empty catch block
        }
        NodeSPI modifierNode = (NodeSPI)modifier.getRoot().getChild(parent);
        assert (modifierNode == null) : "Should be null";
        observerNode = (NodeSPI)observer.getRoot().getChild(parent);
        assert (observerNode == null) : "Should be null";
        NodeSPI modifierTombstone = modifierImpl.peek(parent, true, true);
        NodeSPI observerTombstone = observerImpl.peek(parent, true, true);
        assert (modifierTombstone != null) : "Tombstone should still exist";
        assert (observerTombstone != null) : "Tombstone should still exist";
        assert (!modifierTombstone.isValid()) : "Should not be valid";
        assert (!observerTombstone.isValid()) : "Should not be valid";
        assert (((DefaultDataVersion)modifierTombstone.getVersion()).getRawVersion() == 2L) : "Should retain versioning";
        assert (((DefaultDataVersion)observerTombstone.getVersion()).getRawVersion() == 2L) : "Should retain versioning";
    }
}

