/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.EvictionController;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class BuddyReplicationWithCacheLoaderTest
extends BuddyReplicationTestsBase {
    protected Fqn fqn = Fqn.fromString((String)"/test/br/four/level");
    protected String key = "key";
    protected String value = "value";
    protected boolean passivation = false;

    private CacheLoader[] getLoaders(List<CacheSPI<Object, Object>> caches) {
        CacheLoader[] retVal = new CacheLoader[caches.size()];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = caches.get(i).getCacheLoaderManager().getCacheLoader();
        }
        return retVal;
    }

    public void testWithDataGravitationDefault() throws Exception {
        this.dataGravitationDefaultTest(true);
    }

    public void testWithDataGravitationDefaultNoAuto() throws Exception {
        this.dataGravitationDefaultTest(false);
    }

    private void dataGravitationDefaultTest(boolean autoGravitate) throws Exception {
        int i;
        List<CacheSPI<Object, Object>> caches = this.createCachesWithCacheLoader(3, autoGravitate, true, this.passivation);
        this.cachesTL.set(caches);
        CacheLoader[] loaders = this.getLoaders(caches);
        for (i = 0; i < 3; ++i) {
            loaders[i].remove(Fqn.ROOT);
        }
        for (i = 0; i < 3; ++i) {
            System.out.println("Loader " + i + ": " + loaders[i].get(this.fqn));
        }
        caches.get(0).put(this.fqn, (Object)this.key, (Object)this.value);
        this.assertNoLocks(caches);
        for (i = 0; i < 3; ++i) {
            System.out.println("Loader " + i + ": " + loaders[i].get(this.fqn));
        }
        TestingUtil.dumpCacheContents(caches);
        if (!autoGravitate) {
            caches.get(2).getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
        }
        AssertJUnit.assertEquals((Object)this.value, (Object)caches.get(2).get(this.fqn, (Object)this.key));
        this.cleanupDelay();
        this.assertNoLocks(caches);
        for (i = 0; i < 3; ++i) {
            System.out.println("Loader " + i + ": " + loaders[i].get(this.fqn));
        }
        TestingUtil.dumpCacheContents(caches);
        AssertJUnit.assertTrue((String)"should not exist in cache0", (!caches.get(0).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in cache1", (!caches.get(1).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should exist in cache2", (boolean)caches.get(2).exists(this.fqn));
        AssertJUnit.assertTrue((String)"should not exist in loader0", (!loaders[0].exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in loader1", (!loaders[1].exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should exist in loader2", (boolean)(this.passivation ? !loaders[2].exists(this.fqn) : loaders[2].exists(this.fqn)));
        Fqn b1 = this.fqnTransformer.getBackupFqn(caches.get(0).getLocalAddress(), this.fqn);
        Fqn b2 = this.fqnTransformer.getBackupFqn(caches.get(2).getLocalAddress(), this.fqn);
        AssertJUnit.assertTrue((String)"should not exist in cache0", (!caches.get(0).exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should exist in cache0", (boolean)caches.get(0).exists(b2));
        AssertJUnit.assertTrue((String)"should not exist in cache1", (!caches.get(1).exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in cache1", (!caches.get(1).exists(b2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in cache2", (!caches.get(2).exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in cache2", (!caches.get(2).exists(b2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in loader0", (!loaders[0].exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should exist in loader0", (boolean)(this.passivation ? !loaders[0].exists(b2) : loaders[0].exists(b2)));
        AssertJUnit.assertTrue((String)"should not exist in loaders1", (!loaders[1].exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in loaders1", (!loaders[1].exists(b2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in loaders2", (!loaders[2].exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in loaders2", (!loaders[2].exists(b2) ? 1 : 0) != 0);
    }

    public void testWithDataGravitationEvictOnFind() throws Exception {
        this.dataGravitationEvictionTest(true);
    }

    public void testWithDataGravitationEvictOnFindNoAuto() throws Exception {
        this.dataGravitationEvictionTest(false);
    }

    private void dataGravitationEvictionTest(boolean autoGravitate) throws Exception {
        List<CacheSPI<Object, Object>> caches = this.createCachesWithCacheLoader(3, autoGravitate, false, this.passivation);
        this.cachesTL.set(caches);
        CacheLoader[] loaders = this.getLoaders(caches);
        Fqn b1 = this.fqnTransformer.getBackupFqn(caches.get(0).getLocalAddress(), this.fqn);
        Fqn b2 = this.fqnTransformer.getBackupFqn(caches.get(2).getLocalAddress(), this.fqn);
        caches.get(0).put(this.fqn, (Object)this.key, (Object)this.value);
        Map m = loaders[1].get(b1);
        System.out.println("From loader:  " + m);
        System.out.println("*** About do cause a gravitation event ... ");
        if (!autoGravitate) {
            caches.get(2).getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
        }
        AssertJUnit.assertEquals((Object)this.value, (Object)caches.get(2).get(this.fqn, (Object)this.key));
        this.cleanupDelay();
        AssertJUnit.assertTrue((String)"should not exist in cache0", (!caches.get(0).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in cache1", (!caches.get(1).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should exist in cache2", (boolean)caches.get(2).exists(this.fqn));
        AssertJUnit.assertTrue((String)"should exist in loader0", (boolean)loaders[0].exists(this.fqn));
        AssertJUnit.assertTrue((String)"should not exist in loader1", (!loaders[1].exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should exist in loader2", (boolean)(this.passivation ? !loaders[2].exists(this.fqn) : loaders[2].exists(this.fqn)));
        AssertJUnit.assertTrue((String)"should not exist in cache0", (!caches.get(0).exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should exist in cache0", (boolean)caches.get(0).exists(b2));
        AssertJUnit.assertTrue((String)"should not exist in cache1", (!caches.get(1).exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in cache1", (!caches.get(1).exists(b2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in cache2", (!caches.get(2).exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in cache2", (!caches.get(2).exists(b2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in loader0", (!loaders[0].exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should exist in loader0", (boolean)(this.passivation ? !loaders[0].exists(b2) : loaders[0].exists(b2)));
        AssertJUnit.assertTrue((String)"should exist in loaders1", (boolean)loaders[1].exists(b1));
        AssertJUnit.assertTrue((String)"should not exist in loaders1", (!loaders[1].exists(b2) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in loaders2", (!loaders[2].exists(b1) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)"should not exist in loaders2", (!loaders[2].exists(b2) ? 1 : 0) != 0);
    }

    public void testLocalGravitationOfEvictedNodes() throws Exception {
        CacheSPI cache1 = this.createCacheWithCacheLoader(true, true, this.passivation, true, false);
        Configuration cfg1 = cache1.getConfiguration();
        this.configureEviction(cfg1);
        Configuration cfg0 = cfg1.clone();
        CacheSPI cache0 = (CacheSPI)new UnitTestCacheFactory().createCache(cfg0, false);
        ArrayList<CacheSPI> caches = new ArrayList<CacheSPI>();
        this.cachesTL.set(caches);
        caches.add(cache0);
        caches.add(cache1);
        cache0.start();
        cache1.start();
        TestingUtil.blockUntilViewsReceived(caches.toArray(new Cache[caches.size()]), (long)(5000 * caches.size()));
        TestingUtil.sleepThread(this.getSleepTimeout());
        Fqn foo = Fqn.fromString((String)"/foo");
        Fqn backupFoo = this.fqnTransformer.getBackupFqn(cache0.getLocalAddress(), foo);
        cache0.put(foo, (Object)"key", (Object)"value");
        assert (cache0.exists(foo)) : "Data should exist in data owner";
        assert (cache1.exists(backupFoo)) : "Buddy should have data";
        new EvictionController((Cache)cache0).startEviction();
        new EvictionController((Cache)cache1).startEviction();
        assert (!cache0.exists(foo)) : "Data should have evicted in data owner";
        assert (!cache1.exists(backupFoo)) : "Buddy should have data evicted";
        assert (cache0.getCacheLoaderManager().getCacheLoader().get(foo) != null) : "Should exist in data owner's cache loader";
        assert (cache1.getCacheLoaderManager().getCacheLoader().get(backupFoo) != null) : "Should exist in buddy's loader";
        AssertJUnit.assertEquals((String)"Passivated value available from buddy", (Object)"value", (Object)cache1.get(foo, (Object)"key"));
    }

    public void testRemoteGravitationOfEvictedNodes() throws Exception {
        CacheSPI cache0 = this.createCacheWithCacheLoader(true, true, this.passivation, true, false);
        Configuration cfg0 = cache0.getConfiguration();
        this.configureEviction(cfg0);
        Configuration cfg1 = cfg0.clone();
        CacheSPI cache1 = (CacheSPI)new UnitTestCacheFactory().createCache(cfg1, false);
        Configuration cfg2 = cfg0.clone();
        CacheSPI cache2 = (CacheSPI)new UnitTestCacheFactory().createCache(cfg2, false);
        ArrayList<CacheSPI> caches = new ArrayList<CacheSPI>();
        this.cachesTL.set(caches);
        caches.add(cache0);
        caches.add(cache1);
        caches.add(cache2);
        cache0.start();
        cache1.start();
        cache2.start();
        TestingUtil.blockUntilViewsReceived(caches.toArray(new Cache[caches.size()]), 600000L);
        TestingUtil.sleepThread(this.getSleepTimeout());
        assert (cache0.getBuddyManager().getBuddyAddresses().contains(cache1.getLocalAddress())) : "Cache1 should be cache0's buddy!";
        Fqn foo = Fqn.fromString((String)"/foo");
        Fqn backupFoo = this.fqnTransformer.getBackupFqn(cache0.getLocalAddress(), foo);
        cache0.put(foo, (Object)"key", (Object)"value");
        assert (cache0.exists(foo)) : "Data should exist in data owner";
        assert (cache1.exists(backupFoo)) : "Buddy should have data";
        new EvictionController((Cache)cache0).startEviction();
        new EvictionController((Cache)cache1).startEviction();
        assert (!cache0.exists(foo)) : "Data should have evicted in data owner";
        assert (!cache1.exists(backupFoo)) : "Buddy should have data evicted";
        assert (cache0.getCacheLoaderManager().getCacheLoader().get(foo) != null) : "Should exist in data owner's loader";
        assert (cache1.getCacheLoaderManager().getCacheLoader().get(backupFoo) != null) : "Should exist in buddy's loader";
        AssertJUnit.assertEquals((String)"Passivated value available from buddy", (Object)"value", (Object)cache2.get(foo, (Object)"key"));
    }

    private void configureEviction(Configuration cfg) {
        EvictionConfig ec = new EvictionConfig();
        ec.setWakeupInterval(5000L);
        EvictionRegionConfig erc = new EvictionRegionConfig();
        erc.setRegionFqn(Fqn.ROOT);
        LRUAlgorithmConfig lruAlgorithmConfig = new LRUAlgorithmConfig();
        lruAlgorithmConfig.setMaxAge(0L);
        lruAlgorithmConfig.setTimeToLive(0L);
        lruAlgorithmConfig.setMaxNodes(1);
        erc.setEvictionAlgorithmConfig((EvictionAlgorithmConfig)lruAlgorithmConfig);
        ec.setDefaultEvictionRegionConfig(erc);
        cfg.setEvictionConfig(ec);
    }

    private void cleanupDelay() {
        TestingUtil.sleepThread(250L);
    }
}

