/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.cluster;

import java.util.Collections;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import org.easymock.EasyMock;
import org.jboss.cache.Cache;
import org.jboss.cache.RPCManager;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.cluster.ReplicationQueue;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.ReplicationQueueNotifier;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class ReplicationQueueTest {
    private static final int COUNT = 10;
    Cache cache;
    Cache cache2;
    ReplicationQueue replQ;
    ComponentRegistry registry;
    RPCManager originalRpcManager;

    @BeforeMethod
    public void setUp() throws CloneNotSupportedException {
        Configuration c = new Configuration();
        c.setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        c.setUseReplQueue(true);
        c.setReplQueueMaxElements(10);
        c.setReplQueueInterval(-1L);
        this.cache = new UnitTestCacheFactory().createCache(c, false);
        this.cache.start();
        this.registry = TestingUtil.extractComponentRegistry(this.cache);
        this.replQ = (ReplicationQueue)this.registry.getComponent(ReplicationQueue.class);
        this.originalRpcManager = this.cache.getConfiguration().getRuntimeConfig().getRPCManager();
        this.cache2 = new UnitTestCacheFactory().createCache(this.cache.getConfiguration().clone());
        TestingUtil.blockUntilViewsReceived(60000L, this.cache, this.cache2);
    }

    @AfterMethod
    public void tearDown() {
        this.injectRpcManager(this.originalRpcManager);
        TestingUtil.killCaches(this.cache, this.cache2);
        this.cache = null;
        this.cache2 = null;
    }

    private void injectRpcManager(RPCManager manager) {
        this.registry.registerComponent((Object)manager, RPCManager.class);
    }

    public void testQueueHoldAndFlush() throws Exception {
        assert (this.replQ != null);
        RPCManager mockRpcManager = (RPCManager)EasyMock.createStrictMock(RPCManager.class);
        this.injectRpcManager(mockRpcManager);
        EasyMock.expect((Object)mockRpcManager.getMembers()).andReturn((Object)this.originalRpcManager.getMembers()).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockRpcManager});
        for (int i = 0; i < 9; ++i) {
            this.cache.put("/a/b/c/" + i, (Object)"k", (Object)"v");
        }
        assert (this.replQ.elements.size() == 9);
        EasyMock.verify((Object[])new Object[]{mockRpcManager});
        EasyMock.reset((Object[])new Object[]{mockRpcManager});
        EasyMock.expect((Object)mockRpcManager.getMembers()).andReturn((Object)this.originalRpcManager.getMembers()).anyTimes();
        EasyMock.expect((Object)mockRpcManager.callRemoteMethods((Vector)EasyMock.anyObject(), (ReplicableCommand)EasyMock.anyObject(), EasyMock.anyBoolean(), EasyMock.anyLong(), EasyMock.anyBoolean())).andReturn(Collections.emptyList()).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockRpcManager});
        this.cache.put("/a/b/c/LAST", (Object)"k", (Object)"v");
        assert (this.replQ.elements.size() == 0);
        EasyMock.verify((Object[])new Object[]{mockRpcManager});
    }

    public void testFlushConcurrency() throws Exception {
        int numThreads = 25;
        int numLoopsPerThread = 1000;
        int totalInvocations = 25000;
        assert (totalInvocations % 10 == 0) : "NumThreads and NumLoopsPerThread must multiply to be a multiple of COUNT";
        final CountDownLatch latch = new CountDownLatch(1);
        RPCManager mockRpcManager = (RPCManager)EasyMock.createStrictMock(RPCManager.class);
        this.injectRpcManager(mockRpcManager);
        EasyMock.expect((Object)mockRpcManager.getMembers()).andReturn((Object)this.originalRpcManager.getMembers()).anyTimes();
        EasyMock.expect((Object)mockRpcManager.callRemoteMethods((Vector)EasyMock.anyObject(), (ReplicableCommand)EasyMock.anyObject(), EasyMock.anyBoolean(), EasyMock.anyLong(), EasyMock.anyBoolean())).andReturn(Collections.emptyList()).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockRpcManager});
        Thread[] threads = new Thread[25];
        for (int i = 0; i < 25; ++i) {
            threads[i] = new Thread(){

                public void run() {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    for (int j = 0; j < 1000; ++j) {
                        ReplicationQueueTest.this.cache.put("/a/b/c/" + this.getName() + "/" + j, (Object)"k", (Object)"v");
                    }
                }
            };
            threads[i].start();
        }
        latch.countDown();
        for (Thread t : threads) {
            t.join();
        }
        EasyMock.verify((Object[])new Object[]{mockRpcManager});
        ReplicationQueueNotifier notifier = new ReplicationQueueNotifier(this.cache);
        notifier.waitUntillAllReplicated(250L);
        assert (this.replQ.elements.size() == 0);
    }

    public void testFailure() throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            System.out.println("on put i = " + i);
            this.cache.put("/a/b/c" + i, (Object)"key", (Object)"value");
            AssertJUnit.assertNotNull((Object)this.cache.get("/a/b/c" + i, (Object)"key"));
        }
        ReplicationQueueNotifier notifier = new ReplicationQueueNotifier(this.cache);
        notifier.waitUntillAllReplicated(500L);
        for (int i = 0; i < 10; ++i) {
            AssertJUnit.assertNotNull((String)("on get i = " + i), (Object)this.cache2.get("/a/b/c" + i, (Object)"key"));
        }
    }
}

