/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.legacy.write;

import java.util.Collections;
import org.easymock.EasyMock;
import org.jboss.cache.commands.legacy.write.PessClearDataCommand;
import org.jboss.cache.commands.write.AbstractVersionedDataCommand;
import org.jboss.cache.commands.write.AbstractVersionedDataCommandTest;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true)
public class ClearDataCommandTest
extends AbstractVersionedDataCommandTest {
    PessClearDataCommand command;

    public AbstractVersionedDataCommand moreSetUp() {
        this.command = new PessClearDataCommand(this.globalTransaction, this.fqn);
        this.command.setDataVersion(this.dataVersion);
        return this.command;
    }

    public void testNonexistentNode() {
        EasyMock.expect((Object)this.container.peek(this.fqn)).andReturn(null);
        EasyMock.expect((Object)this.container.peek(this.fqn)).andReturn(null);
        this.control.replay();
        assert (null == this.command.perform(this.ctx));
        this.control.verify();
    }

    public void testExistentDataVersioned() {
        this.nodes.adfgNode.put("key", "value");
        this.nodes.adfgNode.setVersion(this.dataVersion);
        EasyMock.expect((Object)this.container.peek(this.fqn)).andReturn((Object)this.nodes.adfgNode);
        EasyMock.expect((Object)this.container.peek(this.fqn)).andReturn((Object)this.nodes.adfgNode);
        this.notifier.notifyNodeModified(this.fqn, true, NodeModifiedEvent.ModificationType.REMOVE_DATA, this.nodes.adfgNode.getDataDirect(), this.ctx);
        this.notifier.notifyNodeModified(this.fqn, false, NodeModifiedEvent.ModificationType.REMOVE_DATA, Collections.EMPTY_MAP, this.ctx);
        this.control.replay();
        assert (null == this.command.perform(this.ctx));
        assert (this.nodes.adfgNode.getData().isEmpty());
        this.control.verify();
        this.control.reset();
        EasyMock.expect((Object)this.container.peek(this.fqn, false, true)).andReturn((Object)this.nodes.aNode);
        this.control.replay();
        this.command.rollback();
        assert (this.nodes.aNode.dataSize() == 1);
        assert (this.nodes.aNode.getData().get("key").equals("value"));
    }

    public void testExistentDataUnversioned() {
        this.command.setDataVersion(null);
        this.nodes.adfgNode.put("key", "value");
        EasyMock.expect((Object)this.container.peek(this.fqn)).andReturn((Object)this.nodes.adfgNode);
        EasyMock.expect((Object)this.container.peek(this.fqn)).andReturn((Object)this.nodes.adfgNode);
        this.notifier.notifyNodeModified(this.fqn, true, NodeModifiedEvent.ModificationType.REMOVE_DATA, this.nodes.adfgNode.getDataDirect(), this.ctx);
        this.notifier.notifyNodeModified(this.fqn, false, NodeModifiedEvent.ModificationType.REMOVE_DATA, Collections.EMPTY_MAP, this.ctx);
        this.control.replay();
        assert (null == this.command.perform(this.ctx));
        assert (this.nodes.adfgNode.getData().isEmpty());
        this.control.verify();
        this.control.reset();
        EasyMock.expect((Object)this.container.peek(this.fqn, false, true)).andReturn((Object)this.nodes.aNode);
        this.control.replay();
        this.command.rollback();
        assert (this.nodes.aNode.dataSize() == 1);
        assert (this.nodes.aNode.getData().get("key").equals("value"));
    }

    public void testNoOpRollback() {
        block2: {
            EasyMock.expect((Object)this.container.peek(this.fqn, false, true)).andReturn(null);
            this.control.replay();
            try {
                this.command.rollback();
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"should not fail but expect this scenarion");
            }
        }
    }
}

