/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.legacy.write;

import java.util.Collections;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DataContainer;
import org.jboss.cache.commands.legacy.write.VersionedInvalidateCommand;
import org.jboss.cache.commands.read.AbstractDataCommandTest;
import org.jboss.cache.mock.MockNodesFixture;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DataVersioningException;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true)
public class VersionedInvalidateCommandTest
extends AbstractDataCommandTest {
    DataVersion dataVersion;
    VersionedInvalidateCommand command;
    IMocksControl control;
    Notifier notifier;
    TransactionManager tmMock;
    MockNodesFixture nodes;
    CacheSPI spiMock;

    protected void moreSetup() {
        this.control = EasyMock.createStrictControl();
        this.notifier = (Notifier)this.control.createMock(Notifier.class);
        this.container = (DataContainer)this.control.createMock(DataContainer.class);
        this.tmMock = (TransactionManager)this.control.createMock(TransactionManager.class);
        this.spiMock = (CacheSPI)this.control.createMock(CacheSPI.class);
        this.nodes = new MockNodesFixture();
        this.command = new VersionedInvalidateCommand(this.testFqn);
        this.dataVersion = new DefaultDataVersion(10L);
        this.command.setDataVersion(this.dataVersion);
        this.command.initialize(this.spiMock, this.container, this.notifier);
        this.command.initialize(this.tmMock);
    }

    public void testWithExistingNode() {
        this.nodes.adfNode.put("key", "value");
        this.nodes.adfNode.setVersion(this.dataVersion);
        this.nodes.adfNode.setDataLoaded(true);
        EasyMock.expect((Object)this.spiMock.getNode(this.testFqn)).andReturn((Object)this.nodes.adfNode);
        this.notifier.notifyNodeInvalidated(this.testFqn, true, this.ctx);
        this.notifier.notifyNodeInvalidated(this.testFqn, false, this.ctx);
        this.control.replay();
        assert (null == this.command.perform(this.ctx));
        assert (this.nodes.adfNode.getData().isEmpty());
        assert (!this.nodes.adfNode.isDataLoaded());
        assert (!this.nodes.adfNode.isValid());
        assert (this.nodes.adfNode.getVersion().equals(this.dataVersion));
        this.control.verify();
    }

    public void testWithExistingNodeInvalidVersion() {
        this.nodes.adfNode.put("key", "value");
        this.nodes.adfNode.setDataLoaded(true);
        this.nodes.adfNode.setVersion((DataVersion)new DefaultDataVersion(100L));
        EasyMock.expect((Object)this.spiMock.getNode(this.testFqn)).andReturn((Object)this.nodes.adfNode);
        this.control.replay();
        try {
            this.command.perform(this.ctx);
            assert (false) : "exception expected";
        }
        catch (DataVersioningException dataVersioningException) {
            // empty catch block
        }
        assert (!this.nodes.adfNode.getData().isEmpty());
        assert (this.nodes.adfNode.isDataLoaded());
        assert (this.nodes.adfNode.isValid());
        assert (!this.dataVersion.equals(this.nodes.adfNode.getVersion()));
        this.control.verify();
    }

    public void testExistingTombstone() {
        this.nodes.adfNode.setValid(false, true);
        this.nodes.adfNode.setVersion(this.dataVersion);
        EasyMock.expect((Object)this.spiMock.getNode(this.testFqn)).andReturn(null);
        EasyMock.expect((Object)this.container.peek(this.testFqn, true, true)).andReturn((Object)this.nodes.adfNode);
        this.notifier.notifyNodeInvalidated(this.testFqn, true, this.ctx);
        this.notifier.notifyNodeInvalidated(this.testFqn, false, this.ctx);
        this.control.replay();
        assert (null == this.command.perform(this.ctx));
        assert (this.nodes.adfNode.getData().isEmpty());
        assert (!this.nodes.adfNode.isDataLoaded());
        assert (!this.nodes.adfNode.isValid());
        assert (this.nodes.adfNode.getVersion().equals(this.dataVersion));
        this.control.verify();
    }

    public void testCreateTombstone() throws Exception {
        Transaction tx = (Transaction)this.control.createMock(Transaction.class);
        EasyMock.expect((Object)this.tmMock.suspend()).andReturn((Object)tx);
        this.spiMock.put(this.testFqn, Collections.emptyMap());
        this.tmMock.resume(tx);
        this.control.replay();
        this.command.createTombstone(this.ctx);
        this.control.verify();
    }

    public void testCreateTombstoneNoTx() throws Exception {
        EasyMock.expect((Object)this.tmMock.suspend()).andReturn(null);
        this.spiMock.put(this.testFqn, Collections.EMPTY_MAP);
        this.control.replay();
        this.command.createTombstone(this.ctx);
        this.control.verify();
    }
}

