/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jboss.cache.eviction.EvictionListEntry;
import org.jboss.cache.eviction.EvictionQueueList;
import org.jboss.cache.eviction.NodeEntry;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class EvictionQueueListTest {
    EvictionQueueList list;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.list = new EvictionQueueList();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.list = null;
    }

    public void testAddToBottom() throws Exception {
        int i;
        for (i = 0; i < 100; ++i) {
            NodeEntry ne = new NodeEntry("/" + Integer.toString(i));
            EvictionListEntry listEntry = new EvictionListEntry(ne);
            this.list.addToBottom(listEntry);
        }
        AssertJUnit.assertEquals((int)100, (int)this.list.size());
        for (i = 0; i < 100; ++i) {
            EvictionListEntry entry = this.list.getFirst();
            AssertJUnit.assertEquals((String)("/" + Integer.toString(i)), (String)entry.node.getFqn().toString());
            this.list.remove(entry);
        }
    }

    public void testAddToTop() throws Exception {
        int i;
        for (i = 0; i < 100; ++i) {
            NodeEntry ne = new NodeEntry("/" + Integer.toString(i));
            EvictionListEntry listEntry = new EvictionListEntry(ne);
            this.list.addToTop(listEntry);
        }
        AssertJUnit.assertEquals((int)100, (int)this.list.size());
        for (i = 99; i >= 0; --i) {
            EvictionListEntry entry = this.list.getFirst();
            AssertJUnit.assertEquals((String)("/" + Integer.toString(i)), (String)entry.node.getFqn().toString());
            this.list.remove(entry);
        }
    }

    public void testRemoveAndClear() throws Exception {
        EvictionListEntry listEntry1 = new EvictionListEntry(new NodeEntry("/0"));
        this.list.addToBottom(listEntry1);
        AssertJUnit.assertEquals((Object)this.list.getFirst(), (Object)this.list.getLast());
        EvictionListEntry listEntry2 = new EvictionListEntry(new NodeEntry("/1"));
        this.list.addToBottom(listEntry2);
        EvictionListEntry listEntry3 = new EvictionListEntry(new NodeEntry("/2"));
        this.list.addToBottom(listEntry3);
        EvictionListEntry listEntry4 = new EvictionListEntry(new NodeEntry("/3"));
        this.list.addToBottom(listEntry4);
        EvictionListEntry listEntry5 = new EvictionListEntry(new NodeEntry("/4"));
        this.list.addToBottom(listEntry5);
        EvictionListEntry listEntry6 = new EvictionListEntry(new NodeEntry("/5"));
        this.list.addToBottom(listEntry6);
        AssertJUnit.assertEquals((int)6, (int)this.list.size());
        AssertJUnit.assertEquals((Object)listEntry1, (Object)this.list.getFirst());
        AssertJUnit.assertEquals((Object)listEntry6, (Object)this.list.getLast());
        this.list.remove(this.list.getFirst());
        AssertJUnit.assertEquals((int)5, (int)this.list.size());
        AssertJUnit.assertEquals((Object)listEntry2, (Object)this.list.getFirst());
        this.list.remove(this.list.getLast());
        AssertJUnit.assertEquals((int)4, (int)this.list.size());
        AssertJUnit.assertEquals((Object)listEntry5, (Object)this.list.getLast());
        this.list.remove(listEntry3);
        AssertJUnit.assertEquals((int)3, (int)this.list.size());
        AssertJUnit.assertEquals((Object)listEntry2, (Object)this.list.getFirst());
        AssertJUnit.assertEquals((Object)listEntry5, (Object)this.list.getLast());
        Iterator it = this.list.iterator();
        int count = 0;
        while (it.hasNext()) {
            NodeEntry e = (NodeEntry)it.next();
            if (count == 0) {
                AssertJUnit.assertEquals((Object)listEntry2.node, (Object)e);
            } else if (count == 1) {
                AssertJUnit.assertEquals((Object)listEntry4.node, (Object)e);
            } else if (count == 2) {
                AssertJUnit.assertEquals((Object)listEntry5.node, (Object)e);
            }
            ++count;
        }
        AssertJUnit.assertEquals((int)3, (int)count);
        this.list.clear();
        AssertJUnit.assertEquals((int)0, (int)this.list.size());
        boolean caught = false;
        try {
            this.list.getFirst();
        }
        catch (NoSuchElementException e) {
            caught = true;
        }
        AssertJUnit.assertTrue((boolean)caught);
        caught = false;
        try {
            this.list.getLast();
        }
        catch (NoSuchElementException e) {
            caught = true;
        }
        AssertJUnit.assertTrue((boolean)caught);
    }

    public void testIterator() throws Exception {
        for (int i = 0; i < 100; ++i) {
            NodeEntry ne = new NodeEntry("/" + Integer.toString(i));
            EvictionListEntry listEntry = new EvictionListEntry(ne);
            this.list.addToBottom(listEntry);
        }
        Iterator it = this.list.iterator();
        int count = 0;
        while (it.hasNext()) {
            NodeEntry e = (NodeEntry)it.next();
            AssertJUnit.assertEquals((String)("/" + Integer.toString(count)), (String)e.getFqn().toString());
            it.remove();
            ++count;
        }
        AssertJUnit.assertEquals((int)0, (int)this.list.size());
        it = this.list.iterator();
        AssertJUnit.assertFalse((boolean)it.hasNext());
        for (int i = 0; i < 100; ++i) {
            NodeEntry ne = new NodeEntry("/" + Integer.toString(i));
            EvictionListEntry listEntry = new EvictionListEntry(ne);
            this.list.addToBottom(listEntry);
        }
        it = this.list.iterator();
        boolean caught = false;
        try {
            while (it.hasNext()) {
                this.list.addToBottom(new EvictionListEntry(new NodeEntry("/a/b/c")));
            }
        }
        catch (ConcurrentModificationException e) {
            caught = true;
        }
        AssertJUnit.assertTrue((boolean)caught);
    }

    public void testToArray() throws Exception {
        for (int i = 0; i < 100; ++i) {
            NodeEntry ne = new NodeEntry("/" + Integer.toString(i));
            EvictionListEntry listEntry = new EvictionListEntry(ne);
            this.list.addToTop(listEntry);
        }
        EvictionListEntry[] entries = this.list.toArray();
        AssertJUnit.assertEquals((int)100, (int)entries.length);
        int i = 0;
        int j = 99;
        while (i < 100) {
            AssertJUnit.assertEquals((String)("/" + Integer.toString(j)), (String)entries[i].node.getFqn().toString());
            ++i;
            --j;
        }
    }

    public void testFromArray() throws Exception {
        int i;
        EvictionListEntry[] entries = new EvictionListEntry[100];
        for (i = 0; i < 100; ++i) {
            entries[i] = new EvictionListEntry(new NodeEntry("/" + Integer.toString(i)));
        }
        AssertJUnit.assertEquals((int)0, (int)this.list.size());
        this.list.fromArray(entries);
        AssertJUnit.assertEquals((int)100, (int)this.list.size());
        for (i = 0; i < 100; ++i) {
            AssertJUnit.assertEquals((Object)entries[i], (Object)this.list.getFirst());
            this.list.remove(this.list.getFirst());
        }
        AssertJUnit.assertEquals((int)0, (int)this.list.size());
    }
}

