/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.Fqn;
import org.jboss.cache.RegionImpl;
import org.jboss.cache.RegionManager;
import org.jboss.cache.RegionManagerImpl;
import org.jboss.cache.RegionRegistry;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.eviction.EvictionEvent;
import org.jboss.cache.eviction.EvictionTestsBase;
import org.jboss.cache.eviction.FIFOAlgorithm;
import org.jboss.cache.eviction.FIFOAlgorithmConfig;
import org.jboss.cache.eviction.FIFOQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class FIFOAlgorithmTest
extends EvictionTestsBase {
    RegionManager regionManager;
    FIFOAlgorithm algo;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.regionManager = new RegionManagerImpl();
        ((RegionManagerImpl)this.regionManager).injectDependencies(null, null, null, null, null, new RegionRegistry());
        FIFOAlgorithmConfig config = new FIFOAlgorithmConfig();
        config.setMaxNodes(0);
        this.algo = (FIFOAlgorithm)this.createAndAssignToRegion("/a/b", this.regionManager, (EvictionAlgorithmConfig)config);
    }

    public void testMaxNodes1() throws Exception {
        Fqn fqn;
        int i;
        String fqn2;
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        FIFOAlgorithmConfig config = (FIFOAlgorithmConfig)region.getEvictionRegionConfig().getEvictionAlgorithmConfig();
        config.setMaxNodes(5);
        for (int i2 = 0; i2 < 8; ++i2) {
            Fqn fqn3 = Fqn.fromString((String)("/a/b/" + Integer.toString(i2)));
            region.registerEvictionEvent(fqn3, EvictionEvent.Type.ADD_NODE_EVENT);
        }
        this.algo.process(region.getEvictionEventQueue());
        FIFOQueue queue = (FIFOQueue)this.algo.evictionQueue;
        AssertJUnit.assertEquals((int)5, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        int index = 3;
        for (NodeEntry ne : queue) {
            fqn2 = ne.getFqn().toString();
            AssertJUnit.assertTrue((boolean)fqn2.endsWith("/" + Integer.toString(index)));
            ++index;
        }
        for (i = 3; i < 8; ++i) {
            fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            region.registerEvictionEvent(fqn, EvictionEvent.Type.VISIT_NODE_EVENT);
        }
        for (i = 3; i < 5; ++i) {
            fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            region.registerEvictionEvent(fqn, EvictionEvent.Type.VISIT_NODE_EVENT);
        }
        this.algo.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((int)5, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        index = 3;
        for (NodeEntry ne : queue) {
            fqn2 = ne.getFqn().toString();
            AssertJUnit.assertTrue((boolean)fqn2.endsWith("/" + Integer.toString(index)));
            ++index;
        }
    }

    public void testMaxNodes2() throws Exception {
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        FIFOAlgorithmConfig config = (FIFOAlgorithmConfig)region.getEvictionRegionConfig().getEvictionAlgorithmConfig();
        config.setMaxNodes(500);
        for (int i = 0; i < 500; ++i) {
            Fqn fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            region.registerEvictionEvent(fqn, EvictionEvent.Type.ADD_NODE_EVENT);
        }
        this.algo.process(region.getEvictionEventQueue());
        FIFOQueue queue = (FIFOQueue)this.algo.evictionQueue;
        AssertJUnit.assertEquals((int)500, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        int index = 0;
        for (NodeEntry ne : queue) {
            AssertJUnit.assertTrue((boolean)ne.getFqn().toString().endsWith("/" + Integer.toString(index)));
            ++index;
        }
        for (int i = 500; i < 600; ++i) {
            Fqn fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            region.registerEvictionEvent(fqn, EvictionEvent.Type.ADD_NODE_EVENT);
        }
        this.algo.process(region.getEvictionEventQueue());
        index = 100;
        for (NodeEntry ne : queue) {
            AssertJUnit.assertTrue((boolean)ne.getFqn().toString().endsWith("/" + Integer.toString(index)));
            ++index;
        }
    }
}

