/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DummyInMemoryCacheLoader
extends AbstractCacheLoader {
    protected Map<Fqn, DummyNode> nodes = new ConcurrentHashMap<Fqn, DummyNode>();
    protected Log log = LogFactory.getLog(DummyInMemoryCacheLoader.class);
    protected Map<Object, List<Modification>> transactions = new ConcurrentHashMap<Object, List<Modification>>();
    protected boolean debug;
    protected final Object NULL = new Object(){

        public String toString() {
            return "NULL placeholder";
        }
    };
    protected CacheLoaderConfig.IndividualCacheLoaderConfig config;

    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig config) {
        this.config = config;
        if (config != null && config.getProperties() != null) {
            this.debug = Boolean.parseBoolean(config.getProperties().getProperty("debug", "false"));
        }
    }

    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    public Set<?> getChildrenNames(Fqn fqn) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Calling getChildrenNames on Fqn " + fqn + ".  Data map = " + this.getNodesMap()));
        }
        this.debugMessage("Calling getChildrenNames on Fqn " + fqn + ".  Data map = " + this.getNodesMap());
        if (!this.getNodesMap().containsKey(fqn)) {
            this.log.debug((Object)"node not in loader");
            this.debugMessage("node not in loader");
            return null;
        }
        Set<Object> children = this.findChildren(fqn);
        this.log.debug((Object)("Fqn " + fqn + " has children " + children));
        this.debugMessage("Fqn " + fqn + " has children " + children);
        return children.size() == 0 ? null : children;
    }

    private Set<Object> findChildren(Fqn p) {
        HashSet<Object> c = new HashSet<Object>();
        for (Fqn f : this.getNodesMap().keySet()) {
            if (f.isRoot() || !f.getParent().equals((Object)p)) continue;
            c.add(f.getLastElement());
        }
        return c;
    }

    public Map<Object, Object> get(Fqn name) throws Exception {
        Map<Object, Object> d;
        DummyNode dn = this.getNodesMap().get(name);
        Map<Object, Object> map = d = dn != null ? dn.data : null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Getting data for fqn " + name + " = " + d));
        }
        this.debugMessage("Getting data for fqn " + name + " = " + d);
        return this.stripNULLs(d);
    }

    private Map<Object, Object> stripNULLs(Map<Object, Object> data) {
        if (data == null) {
            return null;
        }
        HashMap<Object, Object> d = new HashMap<Object, Object>(data);
        if (d.containsKey(this.NULL)) {
            Object v = d.remove(this.NULL);
            d.put(null, v);
        }
        HashSet keys = new HashSet();
        for (Map.Entry e : d.entrySet()) {
            if (e.getValue() != this.NULL) continue;
            keys.add(e.getKey());
        }
        for (Map.Entry k : keys) {
            d.put(k, null);
        }
        return d;
    }

    private Map<Object, Object> injectNULLs(Map<Object, Object> data) {
        if (data == null) {
            return null;
        }
        HashMap<Object, Object> d = new HashMap<Object, Object>(data);
        if (d.containsKey(null)) {
            Object v = d.remove(null);
            d.put(this.NULL, v);
        }
        HashSet keys = new HashSet();
        for (Map.Entry e : d.entrySet()) {
            if (e.getValue() != null) continue;
            keys.add(e.getKey());
        }
        for (Map.Entry k : keys) {
            d.put(k, this.NULL);
        }
        return d;
    }

    public boolean exists(Fqn name) throws Exception {
        this.debugMessage("Performing exists() on " + name);
        return this.getNodesMap().containsKey(name == null ? this.NULL : name);
    }

    public Object put(Fqn name, Object key, Object value) throws Exception {
        DummyNode n = this.getNodesMap().get(name);
        if (n == null) {
            n = new DummyNode(name);
        }
        Object k = key == null ? this.NULL : key;
        Object v = value == null ? this.NULL : value;
        Object old = n.data.put(k, v);
        this.getNodesMap().put(name, n);
        this.recursivelyPutParentsIfNeeded(name);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Did a put on " + name + ", data is " + n.data));
        }
        this.debugMessage("Did a put on " + name + ", data is " + n.data);
        return old == this.NULL ? null : old;
    }

    public void put(Fqn name, Map<Object, Object> attributes) throws Exception {
        DummyNode n = this.getNodesMap().get(name);
        if (n == null) {
            n = new DummyNode(name);
        }
        n.data.clear();
        if (attributes != null) {
            n.data.putAll(this.injectNULLs(attributes));
        }
        this.getNodesMap().put(name, n);
        this.recursivelyPutParentsIfNeeded(name);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Did a put on " + name + ", data is " + n.data));
        }
        this.debugMessage("Did a put on " + name + ", data is " + n.data);
    }

    private void recursivelyPutParentsIfNeeded(Fqn node) {
        Fqn parent = node.getParent();
        if (this.getNodesMap().containsKey(parent)) {
            return;
        }
        this.getNodesMap().put(parent, new DummyNode(parent));
        this.recursivelyPutParentsIfNeeded(parent);
    }

    public Object remove(Fqn fqn, Object key) throws Exception {
        this.log.debug((Object)("Removing data from " + fqn));
        this.debugMessage("Removing data from " + fqn);
        DummyNode n = this.getNodesMap().get(fqn);
        if (n == null) {
            n = new DummyNode(fqn);
        }
        Object old = n.data.remove(key == null ? this.NULL : key);
        this.getNodesMap().put(fqn, n);
        return old == this.NULL ? null : old;
    }

    public void remove(Fqn fqn) throws Exception {
        this.log.debug((Object)("Removing fqn " + fqn));
        this.debugMessage("Removing fqn " + fqn);
        this.getNodesMap().remove(fqn);
        this.recursivelyRemoveChildren(fqn);
    }

    private void recursivelyRemoveChildren(Fqn removedParent) {
        for (Fqn f : this.getNodesMap().keySet()) {
            if (!f.getParent().equals((Object)removedParent)) continue;
            this.getNodesMap().remove(f);
            this.recursivelyRemoveChildren(f);
        }
    }

    public void removeData(Fqn fqn) throws Exception {
        this.log.debug((Object)("Removing data from " + fqn));
        this.debugMessage("Removing data from " + fqn);
        DummyNode n = this.getNodesMap().get(fqn);
        if (n == null) {
            n = new DummyNode(fqn);
        }
        n.data.clear();
        this.getNodesMap().put(fqn, n);
    }

    public String toString() {
        return "DummyInMemoryCacheLoader{getNodesMap()=" + this.getNodesMap() + '}';
    }

    protected void debugMessage(String msg) {
        if (this.debug) {
            System.out.println(" DummyInMemoryCacheLoader debug: " + msg);
        }
    }

    protected Map<Fqn, DummyNode> getNodesMap() {
        return this.nodes;
    }

    public void wipe() {
        this.nodes.clear();
    }

    public class DummyNode {
        Map<Object, Object> data = new ConcurrentHashMap<Object, Object>();
        Fqn fqn;

        public DummyNode(Fqn fqn) {
            this.fqn = fqn;
        }

        public String toString() {
            return "Node{data=" + this.data + ", fqn=" + this.fqn + '}';
        }
    }
}

