/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.ArrayList;
import javax.transaction.TransactionManager;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnversionedNode;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.context.ContextFactory;
import org.jboss.cache.factories.context.MVCCContextFactory;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.invocation.NodeInvocationDelegate;
import org.jboss.cache.lock.LockType;
import org.jboss.cache.lock.MVCCLockManager;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit", "mvcc"}, sequential=true)
public class MVCCLockManagerTest {
    MVCCLockManager lm;
    InvocationContextContainer icc;

    @BeforeMethod
    public void setUp() {
        this.icc = new InvocationContextContainer();
        this.icc.injectContextFactory((ContextFactory)new MVCCContextFactory());
        this.lm = new MVCCLockManager();
        TransactionManager tm = this.getTransactionManager();
        this.lm.injectConfiguration(new Configuration());
        this.lm.injectDependencies(null, null, tm, this.icc);
        this.lm.startLockManager();
    }

    protected TransactionManager getTransactionManager() {
        return DummyTransactionManager.getInstance();
    }

    @AfterMethod
    public void tearDown() {
        this.lm = null;
    }

    public void testUsingReadLocks() {
        this.lm.isLocked(null, LockType.READ);
        this.lm.getReadOwners(Fqn.ROOT);
        try {
            this.lm.getReadOwners((NodeSPI)null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testLockReentrancy() throws InterruptedException {
        Fqn fqn = Fqn.fromString((String)"/a/b/c");
        NodeInvocationDelegate node = new NodeInvocationDelegate((InternalNode)new UnversionedNode(fqn));
        assert (this.lm.lock(fqn, LockType.WRITE, null));
        assert (this.lm.isLocked((NodeSPI)node));
        assert (this.lm.lock((NodeSPI)node, LockType.WRITE, null));
        assert (this.lm.isLocked((NodeSPI)node));
        this.lm.unlock((NodeSPI)node, null);
        assert (this.lm.isLocked((NodeSPI)node)) : "Should still be locked";
        assert (this.lm.ownsLock((NodeSPI)node, (Object)Thread.currentThread()));
        this.lm.unlock(fqn, null);
        assert (!this.lm.isLocked((NodeSPI)node)) : "Should not be locked";
    }

    public void testSpreadingOfLocks() {
        ArrayList<Fqn> fqns = new ArrayList<Fqn>(11);
        fqns.add(Fqn.fromString((String)"/"));
        fqns.add(Fqn.fromString((String)"/a"));
        fqns.add(Fqn.fromString((String)"/a/b"));
        fqns.add(Fqn.fromString((String)"/a/b/c"));
        fqns.add(Fqn.fromString((String)"/a/b/c/d"));
        fqns.add(Fqn.fromString((String)"/a/b/c/e"));
        fqns.add(Fqn.fromString((String)"/A"));
        fqns.add(Fqn.fromString((String)"/A/B"));
        fqns.add(Fqn.fromString((String)"/A/B/C"));
        fqns.add(Fqn.fromString((String)"/A/B/C/D"));
        fqns.add(Fqn.fromString((String)"/A/B/C/E"));
        for (Fqn f : fqns) {
            System.out.println("Fqn: " + f + " bucket: " + this.lm.lockContainer.hashToIndex((Object)f));
        }
    }
}

