/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.remote.ReplicateCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.marshall.CacheMarshaller200;
import org.jboss.cache.marshall.CacheMarshaller200Test;
import org.jboss.cache.marshall.CacheMarshaller210;
import org.jboss.cache.marshall.CacheMarshallerTestBase;
import org.jboss.cache.marshall.VersionAwareMarshaller;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class CacheMarshaller210Test
extends CacheMarshaller200Test {
    public CacheMarshaller210Test() {
        this.currentVersion = "2.1.0.GA";
        this.currentVersionShort = 21;
        this.expectedMarshallerClass = CacheMarshaller210.class;
    }

    protected void doMapTest(int size) throws Exception {
        CacheMarshallerTestBase.CacheMarshallerTestBaseTL tl = (CacheMarshallerTestBase.CacheMarshallerTestBaseTL)this.threadLocal.get();
        VersionAwareMarshaller marshaller = tl.marshaller;
        Map map = this.createMap(size);
        Fqn fqn = Fqn.fromString((String)"/my/stuff");
        String key = "key";
        PutKeyValueCommand putCommand = new PutKeyValueCommand(null, fqn, (Object)key, (Object)map);
        ReplicateCommand replicateCommand = new ReplicateCommand((ReplicableCommand)putCommand);
        byte[] buf = marshaller.objectToByteBuffer((Object)replicateCommand);
        AssertJUnit.assertEquals((Object)replicateCommand, (Object)marshaller.objectFromByteBuffer(buf));
    }

    protected Map createMap(int size) {
        HashMap<String, String> map = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            map.put("key-" + i, "value-" + i);
        }
        return map;
    }

    public void testLargeNumberOfObjectReferences() throws Exception {
        this.doMapTest(500000);
    }

    public void testVInts() throws IOException {
        int[] ints;
        CacheMarshallerTestBase.CacheMarshallerTestBaseTL tl = (CacheMarshallerTestBase.CacheMarshallerTestBaseTL)this.threadLocal.get();
        VersionAwareMarshaller marshaller = tl.marshaller;
        CacheMarshaller210 cm210 = (CacheMarshaller210)marshaller.defaultMarshaller;
        CacheMarshaller200 cm200 = (CacheMarshaller200)marshaller.getMarshaller(20);
        for (int i : ints = new int[]{2, 100, 500, 12000, 20000, 500000, 2000000, Integer.MAX_VALUE}) {
            System.out.println("CM200: Number of bytes (i=" + i + ") : " + this.getAndTestSize(cm200, i));
            System.out.println("CM210: Number of bytes (i=" + i + ") : " + this.getAndTestSize((CacheMarshaller200)cm210, i));
        }
    }

    public void testVLongs() throws IOException {
        long[] ints;
        CacheMarshallerTestBase.CacheMarshallerTestBaseTL tl = (CacheMarshallerTestBase.CacheMarshallerTestBaseTL)this.threadLocal.get();
        VersionAwareMarshaller marshaller = tl.marshaller;
        CacheMarshaller210 cm210 = (CacheMarshaller210)marshaller.defaultMarshaller;
        CacheMarshaller200 cm200 = (CacheMarshaller200)marshaller.getMarshaller(20);
        for (long i : ints = new long[]{2L, 100L, 500L, 12000L, 20000L, 500000L, 2000000L, Integer.MAX_VALUE, 2147983647L, Long.MAX_VALUE}) {
            System.out.println("CM200: Number of bytes (i=" + i + ") : " + this.getAndTestSize(cm200, i));
            System.out.println("CM210: Number of bytes (i=" + i + ") : " + this.getAndTestSize((CacheMarshaller200)cm210, i));
        }
    }

    private int getAndTestSize(CacheMarshaller200 m, int i) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        m.writeUnsignedInt(oos, i);
        oos.flush();
        oos.close();
        baos.flush();
        baos.close();
        byte[] bytes = baos.toByteArray();
        int byteL = bytes.length;
        assert (i == m.readUnsignedInt(new ObjectInputStream(new ByteArrayInputStream(bytes))));
        return byteL;
    }

    private int getAndTestSize(CacheMarshaller200 m, long i) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        m.writeUnsignedLong(oos, i);
        oos.flush();
        oos.close();
        baos.flush();
        baos.close();
        byte[] bytes = baos.toByteArray();
        int byteL = bytes.length;
        assert (i == m.readUnsignedLong(new ObjectInputStream(new ByteArrayInputStream(bytes))));
        return byteL;
    }
}

