/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.mgmt;

import java.util.HashMap;
import java.util.List;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.CacheMgmtInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class MgmtCoreTest {
    private static final String CAPITAL = "capital";
    private static final String CURRENCY = "currency";
    private static final String POPULATION = "population";
    private static final String AREA = "area";
    CacheSPI<Object, Object> cache = null;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setExposeManagementStatistics(true);
        this.cache.create();
        this.cache.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache != null) {
            TestingUtil.killCaches(new Cache[]{this.cache});
            this.cache = null;
        }
    }

    public void testCacheMgmt() throws Exception {
        AssertJUnit.assertNotNull((String)"Cache is null.", this.cache);
        this.loadCacheData();
        CacheMgmtInterceptor mgmt = this.getCacheMgmtInterceptor();
        AssertJUnit.assertNotNull((String)"CacheMgmtInterceptor not found.", (Object)mgmt);
        Fqn key = Fqn.fromString((String)"Europe/Austria");
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve capital for " + key), (Object)this.cache.get(key, (Object)CAPITAL));
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve currency for " + key), (Object)this.cache.get(key, (Object)CURRENCY));
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve population for " + key), (Object)this.cache.get(key, (Object)POPULATION));
        key = Fqn.fromString((String)"Europe/England");
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve capital for " + key), (Object)this.cache.get(key, (Object)CAPITAL));
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve currency for " + key), (Object)this.cache.get(key, (Object)CURRENCY));
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve population for " + key), (Object)this.cache.get(key, (Object)POPULATION));
        key = Fqn.fromString((String)"Europe/France");
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve capital for " + key), (Object)this.cache.get(key, (Object)CAPITAL));
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve currency for " + key), (Object)this.cache.get(key, (Object)CURRENCY));
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve population for " + key), (Object)this.cache.get(key, (Object)POPULATION));
        key = Fqn.fromString((String)"Europe/Germany");
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve capital for " + key), (Object)this.cache.get(key, (Object)CAPITAL));
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve currency for " + key), (Object)this.cache.get(key, (Object)CURRENCY));
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve population for " + key), (Object)this.cache.get(key, (Object)POPULATION));
        key = Fqn.fromString((String)"Europe/Italy");
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve capital for " + key), (Object)this.cache.get(key, (Object)CAPITAL));
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve currency for " + key), (Object)this.cache.get(key, (Object)CURRENCY));
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve population for " + key), (Object)this.cache.get(key, (Object)POPULATION));
        key = Fqn.fromString((String)"Europe/Switzerland");
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve capital for " + key), (Object)this.cache.get(key, (Object)CAPITAL));
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve currency for " + key), (Object)this.cache.get(key, (Object)CURRENCY));
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve population for " + key), (Object)this.cache.get(key, (Object)POPULATION));
        key = Fqn.fromString((String)"Europe/Austria");
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to retrieve area for " + key), (Object)this.cache.get(key, (Object)AREA));
        key = Fqn.fromString((String)"Europe/England");
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to retrieve area for " + key), (Object)this.cache.get(key, (Object)AREA));
        key = Fqn.fromString((String)"Europe/France");
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to retrieve area for " + key), (Object)this.cache.get(key, (Object)AREA));
        key = Fqn.fromString((String)"Europe/Germany");
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to retrieve area for " + key), (Object)this.cache.get(key, (Object)AREA));
        key = Fqn.fromString((String)"Europe/Italy");
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to retrieve area for " + key), (Object)this.cache.get(key, (Object)AREA));
        key = Fqn.fromString((String)"Europe/Switzerland");
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to retrieve area for " + key), (Object)this.cache.get(key, (Object)AREA));
        AssertJUnit.assertEquals((String)"NumberOfNodes count error: ", (Object)new Integer(13), (Object)new Integer(mgmt.getNumberOfNodes()));
        AssertJUnit.assertEquals((String)"NumberOfAttributes count error: ", (Object)new Integer(40), (Object)new Integer(mgmt.getNumberOfAttributes()));
        AssertJUnit.assertEquals((String)"Stores count error: ", (Object)new Long(40L), (Object)new Long(mgmt.getStores()));
        AssertJUnit.assertEquals((String)"Evictions count error: ", (Object)new Long(0L), (Object)new Long(mgmt.getEvictions()));
        AssertJUnit.assertEquals((String)"Hits count error: ", (Object)new Long(18L), (Object)new Long(mgmt.getHits()));
        AssertJUnit.assertEquals((String)"Misses count error: ", (Object)new Long(6L), (Object)new Long(mgmt.getMisses()));
        AssertJUnit.assertEquals((String)"HitMissRatio error: ", (Object)0.75, (Object)mgmt.getHitMissRatio());
        AssertJUnit.assertEquals((String)"ReadWriteRatio error: ", (Object)0.6, (Object)mgmt.getReadWriteRatio());
        this.cache.evict(Fqn.fromString((String)"Europe/Czech Republic"));
        this.cache.evict(Fqn.fromString((String)"Europe/Poland"));
        AssertJUnit.assertEquals((String)"NumberOfNodes count error after evictions: ", (Object)new Integer(11), (Object)new Integer(mgmt.getNumberOfNodes()));
        AssertJUnit.assertEquals((String)"NumberOfAttributes count error after evictions: ", (Object)new Integer(34), (Object)new Integer(mgmt.getNumberOfAttributes()));
        AssertJUnit.assertEquals((String)"Stores count error: ", (Object)new Long(40L), (Object)new Long(mgmt.getStores()));
        AssertJUnit.assertEquals((String)"Evictions count error: ", (Object)new Long(2L), (Object)new Long(mgmt.getEvictions()));
        Thread.sleep(1000L);
        long t1 = mgmt.getElapsedTime();
        if (t1 < 1L) {
            AssertJUnit.fail((String)"ElapsedTime should be greater than 0 seconds.");
        }
        if ((t1 = mgmt.getTimeSinceReset()) < 1L) {
            AssertJUnit.fail((String)"TimeSinceReset should be greater than 0 seconds.");
        }
        Thread.sleep(1000L);
        mgmt.resetStatistics();
        t1 = mgmt.getElapsedTime();
        if (t1 < 2L) {
            AssertJUnit.fail((String)"ElapsedTime after reset should be greater than 1 second.");
        }
        if ((t1 = mgmt.getTimeSinceReset()) > 1L) {
            AssertJUnit.fail((String)"TimeSinceReset after reset should be less than 2 seconds.");
        }
        AssertJUnit.assertEquals((String)"NumberOfNodes count error after reset: ", (Object)new Integer(11), (Object)new Integer(mgmt.getNumberOfNodes()));
        AssertJUnit.assertEquals((String)"NumberOfAttributes count error after reset: ", (Object)new Integer(34), (Object)new Integer(mgmt.getNumberOfAttributes()));
        AssertJUnit.assertEquals((String)"Stores count error after reset: ", (Object)new Long(0L), (Object)new Long(mgmt.getStores()));
        AssertJUnit.assertEquals((String)"Evictions count error after reset: ", (Object)new Long(0L), (Object)new Long(mgmt.getEvictions()));
        AssertJUnit.assertEquals((String)"Hits count error after reset: ", (Object)new Long(0L), (Object)new Long(mgmt.getHits()));
        AssertJUnit.assertEquals((String)"Misses count error after reset: ", (Object)new Long(0L), (Object)new Long(mgmt.getMisses()));
    }

    private void loadCacheData() {
        this.cache.put("Europe", new HashMap());
        this.cache.put("Europe/Austria", new HashMap());
        this.cache.put("Europe/Czech Republic", new HashMap());
        this.cache.put("Europe/England", new HashMap());
        this.cache.put("Europe/France", new HashMap());
        this.cache.put("Europe/Germany", new HashMap());
        this.cache.put("Europe/Italy", new HashMap());
        this.cache.put("Europe/Poland", new HashMap());
        this.cache.put("Europe/Switzerland", new HashMap());
        this.cache.put("Europe/Austria", (Object)CAPITAL, (Object)"Vienna");
        this.cache.put("Europe/Czech Republic", (Object)CAPITAL, (Object)"Prague");
        this.cache.put("Europe/England", (Object)CAPITAL, (Object)"London");
        this.cache.put("Europe/France", (Object)CAPITAL, (Object)"Paris");
        this.cache.put("Europe/Germany", (Object)CAPITAL, (Object)"Berlin");
        this.cache.put("Europe/Italy", (Object)CAPITAL, (Object)"Rome");
        this.cache.put("Europe/Poland", (Object)CAPITAL, (Object)"Warsaw");
        this.cache.put("Europe/Switzerland", (Object)CAPITAL, (Object)"Bern");
        this.cache.put("Europe/Austria", (Object)CURRENCY, (Object)"Euro");
        this.cache.put("Europe/Czech Republic", (Object)CURRENCY, (Object)"Czech Koruna");
        this.cache.put("Europe/England", (Object)CURRENCY, (Object)"British Pound");
        this.cache.put("Europe/France", (Object)CURRENCY, (Object)"Euro");
        this.cache.put("Europe/Germany", (Object)CURRENCY, (Object)"Euro");
        this.cache.put("Europe/Italy", (Object)CURRENCY, (Object)"Euro");
        this.cache.put("Europe/Poland", (Object)CURRENCY, (Object)"Zloty");
        this.cache.put("Europe/Switzerland", (Object)CURRENCY, (Object)"Swiss Franc");
        this.cache.put("Europe/Austria", (Object)POPULATION, (Object)8184691);
        this.cache.put("Europe/Czech Republic", (Object)POPULATION, (Object)10241138);
        this.cache.put("Europe/England", (Object)POPULATION, (Object)60441457);
        this.cache.put("Europe/France", (Object)POPULATION, (Object)60656178);
        this.cache.put("Europe/Germany", (Object)POPULATION, (Object)82431390);
        this.cache.put("Europe/Italy", (Object)POPULATION, (Object)58103033);
        this.cache.put("Europe/Poland", (Object)POPULATION, (Object)38635144);
        this.cache.put("Europe/Switzerland", (Object)POPULATION, (Object)7489370);
        HashMap<String, Object> albania = new HashMap<String, Object>(4);
        albania.put(CAPITAL, "Tirana");
        albania.put(CURRENCY, "Lek");
        albania.put(POPULATION, 3563112);
        albania.put(AREA, 28748);
        this.cache.put("Europe/Albania", albania);
        HashMap<String, Object> hungary = new HashMap<String, Object>(4);
        hungary.put(CAPITAL, "Budapest");
        hungary.put(CURRENCY, "Forint");
        hungary.put(POPULATION, 10006835);
        hungary.put(AREA, 93030);
        this.cache.put("Europe/Hungary", hungary);
        HashMap<String, Object> romania = new HashMap<String, Object>(4);
        romania.put(CAPITAL, "Bucharest");
        romania.put(CURRENCY, "Leu");
        romania.put(POPULATION, 22329977);
        romania.put(AREA, 237500);
        this.cache.put("Europe/Romania", romania);
        HashMap<String, Object> slovakia = new HashMap<String, Object>(4);
        slovakia.put(CAPITAL, "Bratislava");
        slovakia.put(CURRENCY, "Slovak Koruna");
        slovakia.put(POPULATION, 5431363);
        slovakia.put(AREA, 48845);
        this.cache.put("Europe/Slovakia", slovakia);
    }

    private CacheMgmtInterceptor getCacheMgmtInterceptor() {
        List interceptors = this.cache.getInterceptorChain();
        if (interceptors.isEmpty()) {
            return null;
        }
        for (CommandInterceptor interceptor : interceptors) {
            if (!(interceptor instanceof CacheMgmtInterceptor)) continue;
            return (CacheMgmtInterceptor)interceptor;
        }
        return null;
    }
}

