/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.mgmt;

import java.util.HashMap;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public abstract class MgmtTestBase {
    protected static final String CAPITAL = "capital";
    protected static final String CURRENCY = "currency";
    protected static final String POPULATION = "population";
    protected static final String AREA = "area";
    protected static final Fqn EUROPE = Fqn.fromString((String)"/Europe");
    protected static final Fqn AUSTRIA = Fqn.fromString((String)"/Europe/Austria");
    protected static final Fqn ENGLAND = Fqn.fromString((String)"/Europe/England");
    protected static final Fqn ALBANIA = Fqn.fromString((String)"/Europe/Albania");
    protected static final Fqn HUNGARY = Fqn.fromString((String)"/Europe/Hungary");
    protected static final Fqn POLAND = Fqn.fromString((String)"/Europe/Poland");
    protected boolean passivation = false;
    protected CacheSPI<String, Object> cache = null;
    protected CacheLoader cl;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = this.createCache();
        this.loadCache();
        this.cl = this.cache.getCacheLoaderManager().getCacheLoader();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache != null) {
            TestingUtil.killCaches(new Cache[]{this.cache});
            this.cache = null;
        }
    }

    protected void loadCache() throws Exception {
        this.cache.put(EUROPE, null);
        HashMap<String, Object> austria = new HashMap<String, Object>();
        austria.put(CAPITAL, "VIENNA");
        austria.put(CURRENCY, "Euro");
        austria.put(POPULATION, 8184691);
        this.cache.put(AUSTRIA, austria);
        HashMap<String, Object> england = new HashMap<String, Object>();
        england.put(CAPITAL, "London");
        england.put(CURRENCY, "British Pound");
        england.put(POPULATION, 60441457);
        this.cache.put(ENGLAND, england);
        HashMap<String, Object> albania = new HashMap<String, Object>(4);
        albania.put(CAPITAL, "Tirana");
        albania.put(CURRENCY, "Lek");
        albania.put(POPULATION, 3563112);
        albania.put(AREA, 28748);
        this.cache.put(ALBANIA, albania);
        HashMap<String, Object> hungary = new HashMap<String, Object>(4);
        hungary.put(CAPITAL, "Budapest");
        hungary.put(CURRENCY, "Forint");
        hungary.put(POPULATION, 10006835);
        hungary.put(AREA, 93030);
        this.cache.put(HUNGARY, hungary);
    }

    private CacheSPI<String, Object> createCache() throws Exception {
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        Configuration c = new Configuration();
        c.setNodeLockingScheme(Configuration.NodeLockingScheme.MVCC);
        c.setCacheMode(Configuration.CacheMode.LOCAL);
        c.setCacheLoaderConfig(this.getCacheLoaderConfig());
        c.setExposeManagementStatistics(true);
        CacheSPI cache = (CacheSPI)instance.createCache(c, false);
        cache.create();
        cache.start();
        return cache;
    }

    private CacheLoaderConfig getCacheLoaderConfig() throws Exception {
        return UnitTestCacheConfigurationFactory.buildSingleCacheLoaderConfig(this.passivation, null, DummyInMemoryCacheLoader.class.getName(), "debug=true", false, false, false, false, false);
    }
}

