/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.passivation;

import java.io.File;
import java.io.FileFilter;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.passivation.PassivationTestsBase;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class PassivationToBdbjeCacheLoaderTest
extends PassivationTestsBase {
    private String tmp_location = System.getProperty("java.io.tmpdir", "c:\\tmp");
    private File dir = new File(this.tmp_location);

    public PassivationToBdbjeCacheLoaderTest() {
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
    }

    protected void configureCache() throws Exception {
        class MyFilter
        implements FileFilter {
            MyFilter() {
            }

            public boolean accept(File file) {
                return file.getName().endsWith(".jdb");
            }
        }
        File[] files = this.dir.listFiles(new MyFilter());
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.isFile() || file.delete()) continue;
                System.err.println("Unable to delete: " + file);
            }
        }
        String tmpDir = System.getProperty("java.io.tmpdir", "/tmp");
        String threadId = Thread.currentThread().getName();
        String tmpCLLoc = tmpDir + "/JBossCache-PassivationToBdbjeCacheLoaderTest-" + threadId;
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        cache.getConfiguration().setCacheLoaderConfig(UnitTestCacheConfigurationFactory.buildSingleCacheLoaderConfig(true, null, "org.jboss.cache.loader.bdbje.BdbjeCacheLoader", "location=" + tmpCLLoc, false, false, false, false, false));
    }
}

