/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction.pessimistic;

import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class AsyncRollbackTxTest {
    private CacheSPI<String, String> cache;
    private TransactionManager tm;
    private Fqn fqn = Fqn.fromString((String)"/test");
    private long sleepTime = 2500L;
    private int txTimeout = 2;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration c = new Configuration();
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.AsyncRollbackTransactionManagerLookup");
        c.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        this.cache = (CacheSPI)instance.createCache(c);
        this.tm = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        this.tm.setTransactionTimeout(this.txTimeout);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        try {
            if (this.tm != null && this.tm.getTransaction() != null) {
                try {
                    this.tm.rollback();
                }
                catch (SystemException e) {}
            }
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
        this.tm = null;
    }

    public void testCommitCreationInSameTx() throws Exception {
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        this.tm.begin();
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((int)2, (int)this.cache.getNumberOfLocksHeld());
        Thread.sleep(this.sleepTime);
        this.tm.commit();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testRollbackCreationInSameTx() throws Exception {
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        this.tm.begin();
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((int)2, (int)this.cache.getNumberOfLocksHeld());
        Thread.sleep(this.sleepTime);
        this.tm.rollback();
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        AssertJUnit.assertFalse((boolean)this.cache.exists(this.fqn));
        AssertJUnit.assertNull((Object)this.cache.peek(this.fqn, true));
    }

    private void doTest(boolean commit, boolean writeLock) throws Exception {
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        SeparateThread t = new SeparateThread(commit, writeLock);
        t.start();
        t.join();
        if (t.getException() != null) {
            throw t.getException();
        }
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        AssertJUnit.assertEquals((String)"v", (String)((String)this.cache.get(this.fqn, (Object)"k")));
    }

    public void testRollbackCreationInDifferentTxReadLock() throws Exception {
        this.doTest(false, false);
    }

    public void testCommitCreationInDifferentTxReadLock() throws Exception {
        this.doTest(true, false);
    }

    public void testRollbackCreationInDifferentTxWriteLock() throws Exception {
        this.doTest(false, true);
    }

    public void testCommitCreationInDifferentTxWriteLock() throws Exception {
        this.doTest(true, true);
    }

    public void testTxTimeoutAndPutAfter() throws Exception {
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        this.tm.begin();
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((int)2, (int)this.cache.getNumberOfLocksHeld());
        AssertJUnit.assertNotNull((Object)this.tm.getTransaction());
        Thread.sleep(this.sleepTime);
        this.tm.rollback();
        AssertJUnit.assertNull((Object)this.tm.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        AssertJUnit.assertFalse((boolean)this.cache.exists(this.fqn));
        AssertJUnit.assertNull((Object)this.cache.peek(this.fqn, true));
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testTxTimeoutAndPutGetAfter() throws Exception {
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        this.tm.begin();
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((int)2, (int)this.cache.getNumberOfLocksHeld());
        AssertJUnit.assertNotNull((Object)this.tm.getTransaction());
        Thread.sleep(this.sleepTime);
        this.tm.rollback();
        AssertJUnit.assertFalse((boolean)this.cache.exists(this.fqn));
        AssertJUnit.assertNull((Object)this.cache.peek(this.fqn, true));
        AssertJUnit.assertNull((Object)this.tm.getTransaction());
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.cache.get(this.fqn, (Object)"k");
        SeparateThread t = new SeparateThread(false, false);
        t.start();
        t.join();
        if (t.getException() != null) {
            throw t.getException();
        }
    }

    private class SeparateThread
    extends Thread {
        Exception e = null;
        boolean commit;
        boolean writeLock;

        public SeparateThread(boolean commit, boolean writeLock) {
            this.commit = commit;
            this.writeLock = writeLock;
        }

        public Exception getException() {
            return this.e;
        }

        public void run() {
            try {
                AsyncRollbackTxTest.this.tm.begin();
                if (this.writeLock) {
                    AsyncRollbackTxTest.this.cache.put(AsyncRollbackTxTest.this.fqn, (Object)"k", (Object)"v2");
                } else {
                    AsyncRollbackTxTest.this.cache.get(AsyncRollbackTxTest.this.fqn, (Object)"k");
                }
                SeparateThread.sleep(2500L);
                if (this.commit) {
                    AsyncRollbackTxTest.this.tm.commit();
                } else {
                    AsyncRollbackTxTest.this.tm.rollback();
                }
                AssertJUnit.assertEquals((int)0, (int)AsyncRollbackTxTest.this.cache.getNumberOfLocksHeld());
            }
            catch (Exception e) {
                this.e = e;
            }
        }
    }
}

