/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util.internals;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.RegionRegistry;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionTimerTask;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.util.TestingUtil;

public class EvictionController {
    CacheSPI cache;
    RegionManager regionManager;
    EvictionTimerTask timerTask;
    long originalWakeupInterval;
    RegionRegistry rr;

    public EvictionController(Cache cache) {
        this.cache = (CacheSPI)cache;
        this.regionManager = this.cache.getRegionManager();
        if (this.regionManager == null) {
            throw new IllegalStateException("Null region manager; is the cache started?");
        }
        this.timerTask = (EvictionTimerTask)TestingUtil.extractField(this.regionManager, "evictionTimerTask");
        if (this.timerTask == null) {
            throw new IllegalStateException("No timer task!!!");
        }
        this.rr = (RegionRegistry)this.cache.getComponentRegistry().getComponent(RegionRegistry.class);
        this.stopEvictionThread();
        this.originalWakeupInterval = cache.getConfiguration().getEvictionConfig().getWakeupInterval();
    }

    public void startEviction() {
        this.startEviction(false);
    }

    public void startEviction(boolean restartEvictionTimerTask) {
        try {
            Method method = EvictionTimerTask.class.getDeclaredMethod("processRegions", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this.timerTask, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        if (restartEvictionTimerTask) {
            this.timerTask.init(this.originalWakeupInterval, null, this.rr);
        }
    }

    public void evictRegionWithTimeToLive(String region) throws Exception {
        EvictionConfig evConfig = this.cache.getConfiguration().getEvictionConfig();
        EvictionRegionConfig erConfig = evConfig.getEvictionRegionConfig(region);
        if (erConfig == null) {
            throw new IllegalStateException("No such region!");
        }
        long ttl = 0L;
        if (!(erConfig.getEvictionAlgorithmConfig() instanceof LRUAlgorithmConfig)) {
            throw new IllegalArgumentException("Only LRU being handled for now; please add other implementations here");
        }
        LRUAlgorithmConfig configuration = (LRUAlgorithmConfig)erConfig.getEvictionAlgorithmConfig();
        ttl = configuration.getTimeToLive();
        TestingUtil.sleepThread(ttl + 500L);
        this.evictRegion(region);
    }

    public void evictRegion(String regionStr) throws Exception {
        for (Region region : this.rr.values()) {
            if (region.getEvictionRegionConfig() == null || !region.getFqn().equals((Object)Fqn.fromString((String)regionStr))) continue;
            Method method = EvictionTimerTask.class.getDeclaredMethod("handleRegion", Region.class);
            method.setAccessible(true);
            method.invoke((Object)this.timerTask, region);
        }
    }

    public Signaller getEvictionThreadSignaller() {
        final Signaller s = new Signaller();
        EvictionTimerTask evictionTimerTask = this.timerTask;
        evictionTimerTask.getClass();
        EvictionTimerTask.Task signallingTask = new EvictionTimerTask.Task(evictionTimerTask){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                s.getToken();
                try {
                    super.run();
                    Object var2_1 = null;
                    s.releaseToken();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    s.releaseToken();
                    throw throwable;
                }
            }
        };
        try {
            Class<EvictionTimerTask> ettClass = EvictionTimerTask.class;
            Field f = ettClass.getDeclaredField("task");
            f.setAccessible(true);
            f.set(this.timerTask, signallingTask);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.timerTask.init(this.originalWakeupInterval, null, this.rr);
        return s;
    }

    public void stopEvictionThread() {
        this.timerTask.stop();
    }

    public static class Signaller {
        Semaphore s = new Semaphore(1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForEvictionThreadCompletion(long time, TimeUnit unit) throws InterruptedException {
            try {
                boolean bl = this.s.tryAcquire(time, unit);
                Object var6_4 = null;
                this.s.release();
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                this.s.release();
                throw throwable;
            }
        }

        void getToken() {
            try {
                this.s.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        void releaseToken() {
            this.s.release();
        }
    }
}

